/*******************************************************************************
 * Copyright (c) 2004, 2018 Red Hat, Inc.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Keith Seitz <keiths@redhat.com> - initial API and implementation
 *    Kent Sebastian <ksebasti@redhat.com>
 *******************************************************************************/
package org.eclipse.linuxtools.internal.oprofile.launch;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.EventConfigCache;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;


/**
 * The main plugin class to be used in the desktop.
 */
public class OprofileLaunchPlugin extends AbstractUIPlugin {
    //The shared instance.
    private static OprofileLaunchPlugin plugin;
    //shared cache instance for configuration
    private static EventConfigCache eventConfigCache = null;

    public static final String PLUGIN_ID = "org.eclipse.linuxtools.oprofile.launch"; //$NON-NLS-1$

    // The launch type ID for profiling
    public static final String ID_LAUNCH_PROFILE = PLUGIN_ID + ".oprofile"; //$NON-NLS-1$

    /* Launch Configuration attributes */

    // Global options \\
    public static final String ATTR_KERNEL_IMAGE_FILE = ID_LAUNCH_PROFILE + ".KERNEL_IMAGE";             //$NON-NLS-1$
    public static final String ATTR_SEPARATE_SAMPLES = ID_LAUNCH_PROFILE + ".SEPARATE_SAMPLES";         //$NON-NLS-1$
    public static final String ATTR_USE_DEFAULT_EVENT = ID_LAUNCH_PROFILE + ".USE_DEFAULT_EVENT";        //$NON-NLS-1$
    public static final String ATTR_EXECUTIONS_NUMBER = ID_LAUNCH_PROFILE + ".EXECUTIONS_NUMBER";        //$NON-NLS-1$

    /**
     * @since 2.1
     */
    public static final String ATTR_OPROFILE_COMBO_TEXT = ID_LAUNCH_PROFILE + ".OPROFILE_COMBO_TEXT";        //$NON-NLS-1$

    // Counter Attributes \\
    private static final String attrCounter(int nr) { return ID_LAUNCH_PROFILE + ".COUNTER_" + nr; }                     //$NON-NLS-1$
    public static final String attrConterEnabled(int nr)  { return attrCounter(nr) + ".ENABLED"; }                     //$NON-NLS-1$
    public static final String attrConterEvent(int nr, int ev) { return attrCounter(nr)  + ".EVENT " + ev; }                         //$NON-NLS-1$
    public static final String attrCounterProfileKernel(int nr) { return attrCounter(nr) + ".PROFILE_KERNEL"; }        //$NON-NLS-1$
    public static final String attrCounterProfileUser(int nr) { return attrCounter(nr) + ".PROFILE_USER"; }         //$NON-NLS-1$
    public static final String attrCounterCount(int nr) { return attrCounter(nr) + ".COUNT"; }                         //$NON-NLS-1$
    public static final String attrCounterUnitMask(int nr) { return  attrCounter(nr) + ".UNIT_MASK"; }                 //$NON-NLS-1$
    public static final String attrCounterUnitMaskName(int nr) { return attrCounter(nr) + ".UNIT_MASK_NAME"; }        //$NON-NLS-1$
    public static final String attrNumberOfEvents(int nr) { return attrCounter(nr) + ".EVENTS"; }                    //$NON-NLS-1$


    public static final String ICON_PATH = "icons/"; //$NON-NLS-1$
    public static final String ICON_EVENT_TAB = ICON_PATH + "event_tab.gif"; //$NON-NLS-1$
    public static final String ICON_GLOBAL_TAB = ICON_PATH + "global_tab.gif"; //$NON-NLS-1$

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static OprofileLaunchPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return imageDescriptorFromPlugin(PLUGIN_ID, path);
    }

    public static EventConfigCache getCache() {
        if (eventConfigCache == null) {
            eventConfigCache = new EventConfigCache();
        }

        return eventConfigCache;
    }
}
