/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationLogger;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.Option;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.Value;

public abstract class ExecutorManager
implements Executor.ExecutorExtension {
    private static final int DEFAULT_REGEX_CACHE_LIMIT = 16;
    private static final float DEFAULT_REGEX_CACHE_LOAD_FACTOR = 0.75f;
    private static final @NonNull EvaluationEnvironment nullEvaluationEnvironment = new EvaluationEnvironment(){

        @Override
        public void add(@NonNull TypedElement referredVariable, @Nullable Object value) {
        }

        @Override
        public void clear() {
        }

        @Override
        public @NonNull Map<Option<?>, Object> clearOptions() {
            return Collections.emptyMap();
        }

        @Override
        public void dispose() {
        }

        @Override
        public <T> @Nullable T getAdapter(java.lang.Class<T> adapterType) {
            return null;
        }

        @Override
        public @NonNull EnvironmentFactory getEnvironmentFactory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @NonNull NamedElement getExecutableObject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @NonNull ModelManager getModelManager() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<Option<?>, Object> getOptions() {
            return null;
        }

        @Override
        public <T> T getValue(@NonNull Option<T> option) {
            return null;
        }

        @Override
        public @Nullable Object getValueOf(@NonNull TypedElement referredVariable) {
            return null;
        }

        @Override
        public @NonNull Set<TypedElement> getVariables() {
            return Collections.emptySet();
        }

        @Override
        public boolean isEnabled(@NonNull Option<@Nullable Boolean> option) {
            return false;
        }

        @Override
        public <T> void putOptions(@NonNull Map<? extends Option<T>, ? extends T> options) {
        }

        @Override
        public @Nullable Object remove(@NonNull TypedElement referredVariable) {
            return null;
        }

        @Override
        public <T> @Nullable T removeOption(@NonNull Option<T> option) {
            return null;
        }

        @Override
        public <T> @NonNull Map<Option<T>, T> removeOptions(@NonNull Collection<Option<T>> options) {
            return Collections.emptyMap();
        }

        @Override
        public void replace(@NonNull TypedElement referredVariable, @Nullable Object value) {
        }

        @Override
        public <T> void setOption(@NonNull Option<T> option, @Nullable T value) {
        }
    };
    protected final @NonNull CompleteEnvironment environment;
    protected final @NonNull StandardLibrary standardLibrary;
    private boolean isCanceled = false;
    private Map<String, Pattern> regexPatterns = null;

    public ExecutorManager(@NonNull CompleteEnvironment environment) {
        this.environment = environment;
        this.standardLibrary = environment.getOwnedStandardLibrary();
    }

    @Override
    public void add(@NonNull TypedElement referredVariable, @Nullable Object value) {
    }

    @Override
    @Deprecated
    public @NonNull Evaluator createNestedEvaluator() {
        return this;
    }

    protected @NonNull Map<String, Pattern> createRegexCache() {
        return new LinkedHashMap<String, Pattern>(16, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
                return this.size() > 16;
            }
        };
    }

    @Override
    public void dispose() {
    }

    @Override
    public @NonNull Value evaluate(@NonNull OCLExpression body) {
        throw new UnsupportedOperationException();
    }

    public Value evaluateIteration(Type returnType, CollectionValue sourceVal, TypedElement accumulator, OCLExpression body, TypedElement[] iterators) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull CompleteEnvironment getCompleteEnvironment() {
        return this.environment;
    }

    @Override
    public int getDiagnosticSeverity(int severityPreference, @Nullable Object resultValue) {
        if (resultValue == null) {
            return 4;
        }
        if (resultValue instanceof InvalidValueException) {
            return 8;
        }
        return severityPreference;
    }

    public @NonNull Type getDynamicTypeOf(@Nullable Object value) {
        return this.getIdResolver().getDynamicTypeOf(value);
    }

    @Override
    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull EvaluationEnvironment getEvaluationEnvironment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable EvaluationLogger getLogger() {
        return null;
    }

    @Override
    public @NonNull MetamodelManager getMetamodelManager() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Pattern getRegexPattern(@NonNull String regex) {
        Object object;
        if (this.regexPatterns == null) {
            object = this;
            synchronized (object) {
                if (this.regexPatterns == null) {
                    this.regexPatterns = this.createRegexCache();
                }
            }
        }
        object = this.regexPatterns;
        synchronized (object) {
            Pattern pattern = this.regexPatterns.get(regex);
            if (pattern == null) {
                pattern = Pattern.compile(regex);
                assert (pattern != null);
                this.regexPatterns.put(regex, pattern);
            }
            return pattern;
        }
    }

    @Override
    public int getSeverity(@Nullable Object validationKey) {
        return 2;
    }

    @Override
    public @NonNull StandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value) {
        return this.getIdResolver().getStaticTypeOf(value);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, Object ... values) {
        return this.getIdResolver().getStaticTypeOf(value, values);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return this.getIdResolver().getStaticTypeOf(value, values);
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    @Override
    public void setLogger(@Nullable EvaluationLogger logger) {
    }

    @Override
    public void popEvaluationEnvironment() {
    }

    @Override
    @Deprecated
    public @NonNull EvaluationEnvironment pushEvaluationEnvironment(@NonNull NamedElement executableObject, @Nullable OCLExpression callingObject) {
        return nullEvaluationEnvironment;
    }

    @Override
    public @NonNull EvaluationEnvironment pushEvaluationEnvironment(@NonNull NamedElement executableObject, @Nullable Object caller) {
        return nullEvaluationEnvironment;
    }

    @Override
    public void replace(@NonNull TypedElement referredVariable, @Nullable Object value) {
    }

    @Override
    public void resetCaches() {
    }
}

