/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.SemanticFromGMFElement;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.util.LogOptions;
import org.eclipse.papyrus.uml.diagram.sequence.util.RedirectionCommandStackListener;
import org.eclipse.papyrus.uml.diagram.sequence.util.RedirectionContentAdapter;
import org.eclipse.papyrus.uml.diagram.sequence.util.RedirectionOperationListener;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class SequenceReferenceEditPolicy
extends GraphicalEditPolicy
implements NotificationListener {
    public static final String SEQUENCE_REFERENCE = "SEQUENCE_REFERENCE";
    public static final String NO_ROLE = "NO_ROLE";
    public static final String ROLE_START = "START";
    public static final String ROLE_FINISH = "FINISH";
    public static final String ROLE_SOURCE = "SOURCE";
    public static final String ROLE_TARGET = "TARGET";
    protected HashMap<EditPart, String> weakReferences = new HashMap();
    protected HashMap<EditPart, String> strongReferences = new HashMap();
    protected RedirectionContentAdapter redirectionContentAdapter;
    protected RedirectionCommandStackListener redirectionCommandStackListener;
    protected RedirectionOperationListener redirectionOperationListener;

    public HashMap<EditPart, String> getWeakReferences() {
        return this.weakReferences;
    }

    public HashMap<EditPart, String> getStrongReferences() {
        return this.strongReferences;
    }

    public void activate() {
        super.activate();
        this.redirectionOperationListener = new RedirectionOperationListener(this);
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this.redirectionOperationListener);
        this.updateStrongAndWeakReferences();
    }

    public void deactivate() {
        if (this.redirectionOperationListener != null) {
            OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this.redirectionOperationListener);
        }
        super.deactivate();
    }

    public void updateStrongAndWeakReferences() {
        UMLDiagramEditorPlugin.log.trace(LogOptions.SEQUENCE_DEBUG, "+ Update Strong and weak ref " + this.getHost().getClass().getName());
        this.strongReferences.clear();
        this.weakReferences.clear();
        if (this.getHost() instanceof AbstractExecutionSpecificationEditPart && ((AbstractExecutionSpecificationEditPart)this.getHost()).resolveSemanticElement() instanceof ExecutionSpecification) {
            ExecutionSpecification exec = (ExecutionSpecification)((AbstractExecutionSpecificationEditPart)this.getHost()).resolveSemanticElement();
            this.fillStrongReferencesOfExecutionSpecification(exec);
            if (exec.getCovereds().size() == 1) {
                Lifeline currentLifeline = (Lifeline)exec.getCovereds().get(0);
                this.fillWeakReferenceForExecSpec(exec.getFinish(), currentLifeline);
            }
        }
        if (this.getHost() instanceof AbstractMessageEditPart && ((AbstractMessageEditPart)this.getHost()).resolveSemanticElement() instanceof Message) {
            Lifeline currentLifeline;
            MessageEnd targetEvent;
            Message aMessage = (Message)((AbstractMessageEditPart)this.getHost()).resolveSemanticElement();
            MessageEnd sourceEvent = aMessage.getSendEvent();
            if (sourceEvent instanceof OccurrenceSpecification) {
                this.addExecutionSpecIntoReferences((OccurrenceSpecification)sourceEvent, this.strongReferences, ROLE_SOURCE);
            }
            if ((targetEvent = aMessage.getReceiveEvent()) instanceof OccurrenceSpecification) {
                this.addExecutionSpecIntoReferences((OccurrenceSpecification)targetEvent, this.strongReferences, ROLE_TARGET);
            }
            if (sourceEvent instanceof OccurrenceSpecification && ((OccurrenceSpecification)sourceEvent).getCovereds().size() == 1) {
                currentLifeline = (Lifeline)((OccurrenceSpecification)sourceEvent).getCovereds().get(0);
                this.fillWeakReference((OccurrenceSpecification)sourceEvent, currentLifeline);
            }
            if (targetEvent instanceof OccurrenceSpecification && ((OccurrenceSpecification)targetEvent).getCovereds().size() == 1) {
                currentLifeline = (Lifeline)((OccurrenceSpecification)targetEvent).getCovereds().get(0);
                this.fillWeakReference((OccurrenceSpecification)targetEvent, currentLifeline);
            }
        }
    }

    protected void fillWeakReference(OccurrenceSpecification sourceEvent, Lifeline currentLifeline) {
        Element nextEvent = this.getNextEventFromLifeline(currentLifeline, sourceEvent);
        if (!this.isCoveredByStronReference(nextEvent)) {
            if (nextEvent instanceof MessageOccurrenceSpecification && this.isOnlyMessageEnd((MessageOccurrenceSpecification)nextEvent)) {
                this.addMessageIntoReferences((MessageEnd)nextEvent, this.weakReferences, NO_ROLE);
            } else if (nextEvent instanceof OccurrenceSpecification) {
                this.addExecutionSpecIntoReferences((OccurrenceSpecification)nextEvent, this.weakReferences, NO_ROLE);
            }
        }
    }

    protected void fillWeakReferenceForExecSpec(OccurrenceSpecification sourceEvent, Lifeline currentLifeline) {
        Element nextEvent = this.getNextEventFromLifeline(currentLifeline, sourceEvent);
        if (!this.isCoveredByStronReference(nextEvent)) {
            ExecutionSpecification subExecutionSpec;
            if (nextEvent instanceof MessageOccurrenceSpecification && this.isOnlyMessageEnd((MessageOccurrenceSpecification)nextEvent)) {
                this.addMessageIntoReferences((MessageEnd)nextEvent, this.weakReferences, NO_ROLE);
            } else if (nextEvent instanceof OccurrenceSpecification && !(subExecutionSpec = this.getExecutionSpecificationAssociatedToEvent((OccurrenceSpecification)nextEvent)).getFinish().equals(nextEvent)) {
                this.addExecutionSpecIntoReferences((OccurrenceSpecification)nextEvent, this.weakReferences, NO_ROLE);
            }
        }
    }

    protected ExecutionSpecification getExecutionSpecificationAssociatedToEvent(OccurrenceSpecification event) {
        ExecutionSpecification exec = null;
        if (event != null && !event.getCovereds().isEmpty()) {
            Lifeline currentLifeline = (Lifeline)event.getCovereds().get(0);
            int index = 0;
            while (exec == null && index < currentLifeline.getCoveredBys().size()) {
                if (currentLifeline.getCoveredBys().get(index) instanceof ExecutionSpecification) {
                    ExecutionSpecification currentExec = (ExecutionSpecification)currentLifeline.getCoveredBys().get(index);
                    if (event.equals(currentExec.getStart())) {
                        exec = currentExec;
                    }
                    if (event.equals(currentExec.getFinish())) {
                        exec = currentExec;
                    }
                }
                ++index;
            }
        }
        return exec;
    }

    protected Element getNextEventFromLifeline(Lifeline currentLifeline, Object event) {
        int index = currentLifeline.getCoveredBys().indexOf(event);
        Element nextEvent = null;
        if (index != -1) {
            ++index;
            while (nextEvent == null && index < currentLifeline.getCoveredBys().size()) {
                if (currentLifeline.getCoveredBys().get(index) instanceof MessageEnd || currentLifeline.getCoveredBys().get(index) instanceof OccurrenceSpecification) {
                    nextEvent = (Element)currentLifeline.getCoveredBys().get(index);
                }
                ++index;
            }
        }
        return nextEvent;
    }

    public boolean isCoveredByStronReference(Element event) {
        for (EditPart editPart : this.getStrongReferences().keySet()) {
            if (editPart instanceof AbstractMessageEditPart) {
                Message message = (Message)((AbstractMessageEditPart)editPart).resolveSemanticElement();
                if (message.getSendEvent().equals(event)) {
                    return true;
                }
                if (message.getReceiveEvent().equals(event)) {
                    return true;
                }
            }
            if (!(editPart instanceof AbstractExecutionSpecificationEditPart)) continue;
            ExecutionSpecification exec = (ExecutionSpecification)((AbstractExecutionSpecificationEditPart)editPart).resolveSemanticElement();
            if (exec.getStart().equals(event)) {
                return true;
            }
            if (!exec.getFinish().equals(event)) continue;
            return true;
        }
        return false;
    }

    protected void addMessageIntoReferences(MessageEnd messageEnd, HashMap<EditPart, String> referenceList, String role) {
        IGraphicalEditPart resultedEditPart;
        if (messageEnd.getMessage() != null && (resultedEditPart = this.getEditPartFromSemantic(messageEnd.getMessage())) != null) {
            if (referenceList == this.strongReferences) {
                referenceList.put((EditPart)resultedEditPart, role);
            } else if (referenceList == this.weakReferences && !this.strongReferences.containsKey(resultedEditPart)) {
                referenceList.put((EditPart)resultedEditPart, role);
            }
        }
    }

    protected boolean isOnlyMessageEnd(MessageOccurrenceSpecification messageEnd) {
        InteractionFragment owner = (InteractionFragment)messageEnd.getOwner();
        if (owner != null) {
            for (Element fragment : owner.getOwnedElements()) {
                if (!(fragment instanceof ExecutionSpecification)) continue;
                if (messageEnd.equals(((ExecutionSpecification)fragment).getStart())) {
                    return false;
                }
                if (!messageEnd.equals(((ExecutionSpecification)fragment).getFinish())) continue;
                return false;
            }
        }
        return true;
    }

    protected void addExecutionSpecIntoReferences(OccurrenceSpecification sourceEvent, HashMap<EditPart, String> referenceList, String role) {
        ExecutionSpecification executionSpec = this.getExecutionSpecificationAssociatedToEvent(sourceEvent);
        if (executionSpec != null) {
            IGraphicalEditPart resultedEditPart = this.getEditPartFromSemantic(executionSpec);
            if (referenceList == this.strongReferences) {
                if (resultedEditPart != null) {
                    if (executionSpec.getStart().equals(sourceEvent)) {
                        referenceList.put((EditPart)resultedEditPart, ROLE_START);
                    } else {
                        referenceList.put((EditPart)resultedEditPart, ROLE_FINISH);
                    }
                }
            } else if (referenceList == this.weakReferences && !this.strongReferences.containsKey(resultedEditPart) && resultedEditPart != null) {
                if (executionSpec.getStart().equals(sourceEvent)) {
                    referenceList.put((EditPart)resultedEditPart, ROLE_START);
                } else {
                    referenceList.put((EditPart)resultedEditPart, ROLE_FINISH);
                }
            }
        }
    }

    protected IGraphicalEditPart getEditPartFromSemantic(Object semanticElement) {
        IGraphicalEditPart researchedEditPart = null;
        SemanticFromGMFElement semanticFromGMFElement = new SemanticFromGMFElement();
        EditPartViewer editPartViewer = this.getHost().getViewer();
        if (editPartViewer != null) {
            Iterator iter = editPartViewer.getEditPartRegistry().values().iterator();
            while (iter.hasNext() && researchedEditPart == null) {
                Object currentElement;
                Object currentEditPart = iter.next();
                if (!(currentEditPart instanceof IPrimaryEditPart) || !semanticElement.equals(currentElement = semanticFromGMFElement.getSemanticElement(currentEditPart))) continue;
                researchedEditPart = (IGraphicalEditPart)currentEditPart;
            }
        }
        return researchedEditPart;
    }

    public void notifyChanged(Notification notification) {
        this.updateStrongAndWeakReferences();
    }

    protected Interaction getInteraction() {
        if (this.getHost() instanceof AbstractExecutionSpecificationEditPart && ((AbstractExecutionSpecificationEditPart)this.getHost()).resolveSemanticElement() instanceof ExecutionSpecification) {
            ExecutionSpecification exec = (ExecutionSpecification)((AbstractExecutionSpecificationEditPart)this.getHost()).resolveSemanticElement();
            return exec.getEnclosingInteraction();
        }
        if (this.getHost() instanceof AbstractMessageEditPart && ((AbstractMessageEditPart)this.getHost()).resolveSemanticElement() instanceof Message) {
            Message aMessage = (Message)((AbstractMessageEditPart)this.getHost()).resolveSemanticElement();
            return aMessage.getInteraction();
        }
        return null;
    }

    protected void fillStrongReferencesOfExecutionSpecification(ExecutionSpecification exec) {
        MessageEnd messageEnd;
        if (exec.getStart() instanceof MessageEnd) {
            messageEnd = (MessageEnd)exec.getStart();
            this.addMessageIntoReferences(messageEnd, this.strongReferences, ROLE_START);
        }
        if (exec.getFinish() instanceof MessageEnd) {
            messageEnd = (MessageEnd)exec.getFinish();
            this.addMessageIntoReferences(messageEnd, this.strongReferences, ROLE_FINISH);
        }
        if (exec.getCovereds().size() >= 1) {
            Lifeline currentLifeline = (Lifeline)exec.getCovereds().get(0);
            int index = currentLifeline.getCoveredBys().indexOf((Object)exec);
            Element nextEvent = null;
            OccurrenceSpecification foundSubExecSpec = null;
            if (index != -1) {
                ++index;
                while ((nextEvent != exec.getFinish() || foundSubExecSpec == null) && index < currentLifeline.getCoveredBys().size()) {
                    ExecutionSpecification subExecutionSpec;
                    nextEvent = (Element)currentLifeline.getCoveredBys().get(index);
                    if (nextEvent instanceof OccurrenceSpecification && (subExecutionSpec = this.getExecutionSpecificationAssociatedToEvent((OccurrenceSpecification)nextEvent)) != null && subExecutionSpec.getStart() != null && !subExecutionSpec.equals(exec) && subExecutionSpec.getStart().equals(nextEvent)) {
                        foundSubExecSpec = (OccurrenceSpecification)nextEvent;
                        this.addExecutionSpecIntoReferences(foundSubExecSpec, this.strongReferences, ROLE_START);
                    }
                    ++index;
                }
            }
        }
    }
}

