/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.visitor;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.php.core.compiler.ast.nodes.ASTError;
import org.eclipse.php.core.compiler.ast.nodes.AnonymousClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.core.compiler.ast.nodes.ArrayElement;
import org.eclipse.php.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.core.compiler.ast.nodes.BackTickExpression;
import org.eclipse.php.core.compiler.ast.nodes.BreakStatement;
import org.eclipse.php.core.compiler.ast.nodes.CastExpression;
import org.eclipse.php.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.compiler.ast.nodes.CloneExpression;
import org.eclipse.php.core.compiler.ast.nodes.Comment;
import org.eclipse.php.core.compiler.ast.nodes.ConditionalExpression;
import org.eclipse.php.core.compiler.ast.nodes.ConstantDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ContinueStatement;
import org.eclipse.php.core.compiler.ast.nodes.DeclareStatement;
import org.eclipse.php.core.compiler.ast.nodes.Dispatch;
import org.eclipse.php.core.compiler.ast.nodes.DoStatement;
import org.eclipse.php.core.compiler.ast.nodes.EchoStatement;
import org.eclipse.php.core.compiler.ast.nodes.EmptyStatement;
import org.eclipse.php.core.compiler.ast.nodes.ExpressionStatement;
import org.eclipse.php.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.core.compiler.ast.nodes.FinallyClause;
import org.eclipse.php.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.core.compiler.ast.nodes.ForStatement;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameterByReference;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.core.compiler.ast.nodes.GotoLabel;
import org.eclipse.php.core.compiler.ast.nodes.GotoStatement;
import org.eclipse.php.core.compiler.ast.nodes.IfStatement;
import org.eclipse.php.core.compiler.ast.nodes.IgnoreError;
import org.eclipse.php.core.compiler.ast.nodes.Include;
import org.eclipse.php.core.compiler.ast.nodes.InfixExpression;
import org.eclipse.php.core.compiler.ast.nodes.InstanceOfExpression;
import org.eclipse.php.core.compiler.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ListVariable;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceReference;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallArgumentsList;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PostfixExpression;
import org.eclipse.php.core.compiler.ast.nodes.PrefixExpression;
import org.eclipse.php.core.compiler.ast.nodes.Quote;
import org.eclipse.php.core.compiler.ast.nodes.ReferenceExpression;
import org.eclipse.php.core.compiler.ast.nodes.ReflectionArrayVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.ReflectionCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.ReflectionStaticMethodInvocation;
import org.eclipse.php.core.compiler.ast.nodes.ReflectionVariableReference;
import org.eclipse.php.core.compiler.ast.nodes.ReturnStatement;
import org.eclipse.php.core.compiler.ast.nodes.ReturnType;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.core.compiler.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.compiler.ast.nodes.StaticDispatch;
import org.eclipse.php.core.compiler.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.compiler.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.compiler.ast.nodes.StaticStatement;
import org.eclipse.php.core.compiler.ast.nodes.SwitchCase;
import org.eclipse.php.core.compiler.ast.nodes.SwitchStatement;
import org.eclipse.php.core.compiler.ast.nodes.ThrowStatement;
import org.eclipse.php.core.compiler.ast.nodes.TraitAlias;
import org.eclipse.php.core.compiler.ast.nodes.TraitAliasStatement;
import org.eclipse.php.core.compiler.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.TraitPrecedence;
import org.eclipse.php.core.compiler.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.core.compiler.ast.nodes.TraitUseStatement;
import org.eclipse.php.core.compiler.ast.nodes.TryStatement;
import org.eclipse.php.core.compiler.ast.nodes.UnaryOperation;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.core.compiler.ast.nodes.WhileStatement;
import org.eclipse.php.core.compiler.ast.nodes.YieldExpression;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.util.XMLWriter;

public class ASTPrintVisitor
extends PHPASTVisitor {
    private XMLWriter xmlWriter;
    Map<String, String> EMPTY_MAP = new HashMap<String, String>();

    private ASTPrintVisitor(OutputStream out) throws Exception {
        this.xmlWriter = new XMLWriter(out, false);
    }

    private void close() {
        this.xmlWriter.flush();
        this.xmlWriter.close();
    }

    public static String toXMLString(ASTNode node) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ASTPrintVisitor printVisitor = new ASTPrintVisitor(out);
            node.traverse((ASTVisitor)printVisitor);
            printVisitor.close();
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    protected Map<String, String> createInitialParameters(ASTNode s) throws Exception {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("start", Integer.toString(s.sourceStart()));
        parameters.put("end", Integer.toString(s.sourceEnd()));
        if (s instanceof Declaration) {
            String modifiers;
            Declaration declaration = (Declaration)s;
            StringBuilder buf = new StringBuilder();
            if (declaration.isAbstract()) {
                buf.append(",abstract");
            }
            if (declaration.isFinal()) {
                buf.append(",final");
            }
            if (declaration.isPrivate()) {
                buf.append(",private");
            }
            if (declaration.isProtected()) {
                buf.append(",protected");
            }
            if (declaration.isPublic()) {
                buf.append(",public");
            }
            if (declaration.isStatic()) {
                buf.append(",static");
            }
            parameters.put("modifiers", (modifiers = buf.toString()).length() > 0 ? modifiers.substring(1) : modifiers);
        }
        return parameters;
    }

    @Override
    public boolean endvisit(ArrayCreation s) throws Exception {
        this.xmlWriter.endTag("ArrayCreation");
        return true;
    }

    @Override
    public boolean endvisit(ArrayElement s) throws Exception {
        this.xmlWriter.endTag("ArrayElement");
        return true;
    }

    @Override
    public boolean endvisit(ArrayVariableReference s) throws Exception {
        this.xmlWriter.endTag("ArrayVariableReference");
        return true;
    }

    @Override
    public boolean endvisit(Assignment s) throws Exception {
        this.xmlWriter.endTag("Assignment");
        return true;
    }

    @Override
    public boolean endvisit(ASTError s) throws Exception {
        this.xmlWriter.endTag("ASTError");
        return true;
    }

    @Override
    public boolean endvisit(BackTickExpression s) throws Exception {
        this.xmlWriter.endTag("BackTickExpression");
        return true;
    }

    @Override
    public boolean endvisit(BreakStatement s) throws Exception {
        this.xmlWriter.endTag("BreakStatement");
        return true;
    }

    @Override
    public boolean endvisit(CastExpression s) throws Exception {
        this.xmlWriter.endTag("CastExpression");
        return true;
    }

    @Override
    public boolean endvisit(CatchClause s) throws Exception {
        this.xmlWriter.endTag("CatchClause");
        return true;
    }

    @Override
    public boolean endvisit(FinallyClause s) throws Exception {
        this.xmlWriter.endTag("FinallyClause");
        return true;
    }

    @Override
    public boolean endvisit(ConstantDeclaration s) throws Exception {
        this.xmlWriter.endTag("ConstantDeclaration");
        return true;
    }

    @Override
    public boolean endvisit(ClassDeclaration s) throws Exception {
        this.xmlWriter.endTag("ClassDeclaration");
        return true;
    }

    @Override
    public boolean endvisit(ClassInstanceCreation s) throws Exception {
        this.xmlWriter.endTag("ClassInstanceCreation");
        return true;
    }

    @Override
    public boolean endvisit(CloneExpression s) throws Exception {
        this.xmlWriter.endTag("CloneExpression");
        return true;
    }

    @Override
    public boolean endvisit(Comment s) throws Exception {
        this.xmlWriter.endTag("Comment");
        return true;
    }

    @Override
    public boolean endvisit(ConditionalExpression s) throws Exception {
        this.xmlWriter.endTag("ConditionalExpression");
        return true;
    }

    @Override
    public boolean endvisit(ConstantReference s) throws Exception {
        this.xmlWriter.endTag("ConstantReference");
        return true;
    }

    @Override
    public boolean endvisit(ContinueStatement s) throws Exception {
        this.xmlWriter.endTag("ContinueStatement");
        return true;
    }

    @Override
    public boolean endvisit(DeclareStatement s) throws Exception {
        this.xmlWriter.endTag("DeclareStatement");
        return true;
    }

    @Override
    public boolean endvisit(Dispatch s) throws Exception {
        this.xmlWriter.endTag("Dispatch");
        return true;
    }

    @Override
    public boolean endvisit(DoStatement s) throws Exception {
        this.xmlWriter.endTag("DoStatement");
        return true;
    }

    @Override
    public boolean endvisit(EchoStatement s) throws Exception {
        this.xmlWriter.endTag("EchoStatement");
        return true;
    }

    @Override
    public boolean endvisit(EmptyStatement s) throws Exception {
        this.xmlWriter.endTag("EmptyStatement");
        return true;
    }

    @Override
    public boolean endvisit(ExpressionStatement s) throws Exception {
        this.xmlWriter.endTag("ExpressionStatement");
        return true;
    }

    @Override
    public boolean endvisit(FieldAccess s) throws Exception {
        this.xmlWriter.endTag("FieldAccess");
        return true;
    }

    @Override
    public boolean endvisit(ForEachStatement s) throws Exception {
        this.xmlWriter.endTag("ForEachStatement");
        return true;
    }

    @Override
    public boolean endvisit(FormalParameter s) throws Exception {
        this.xmlWriter.endTag("FormalParameter");
        return true;
    }

    @Override
    public boolean endvisit(FormalParameterByReference s) throws Exception {
        this.xmlWriter.endTag("FormalParameterByReference");
        return true;
    }

    @Override
    public boolean endvisit(ForStatement s) throws Exception {
        this.xmlWriter.endTag("ForStatement");
        return true;
    }

    @Override
    public boolean endvisit(GlobalStatement s) throws Exception {
        this.xmlWriter.endTag("GlobalStatement");
        return true;
    }

    @Override
    public boolean endvisit(IfStatement s) throws Exception {
        this.xmlWriter.endTag("IfStatement");
        return true;
    }

    @Override
    public boolean endvisit(IgnoreError s) throws Exception {
        this.xmlWriter.endTag("IgnoreError");
        return true;
    }

    @Override
    public boolean endvisit(Include s) throws Exception {
        this.xmlWriter.endTag("Include");
        return true;
    }

    @Override
    public boolean endvisit(InfixExpression s) throws Exception {
        this.xmlWriter.endTag("InfixExpression");
        return true;
    }

    @Override
    public boolean endvisit(InstanceOfExpression s) throws Exception {
        this.xmlWriter.endTag("InstanceOfExpression");
        return true;
    }

    @Override
    public boolean endvisit(InterfaceDeclaration s) throws Exception {
        this.xmlWriter.endTag("InterfaceDeclaration");
        return true;
    }

    @Override
    public boolean endvisit(ListVariable s) throws Exception {
        this.xmlWriter.endTag("ListVariable");
        return true;
    }

    @Override
    public boolean endvisit(PHPCallArgumentsList s) throws Exception {
        this.xmlWriter.endTag("PHPCallArgumentsList");
        return true;
    }

    @Override
    public boolean endvisit(PHPCallExpression s) throws Exception {
        this.xmlWriter.endTag("PHPCallExpression");
        return true;
    }

    @Override
    public boolean endvisit(PHPDocBlock s) throws Exception {
        this.xmlWriter.endTag("PHPDocBlock");
        return true;
    }

    @Override
    public boolean endvisit(PHPDocTag s) throws Exception {
        this.xmlWriter.endTag("PHPDocTag");
        return true;
    }

    @Override
    public boolean endvisit(PHPFieldDeclaration s) throws Exception {
        this.xmlWriter.endTag("PHPFieldDeclaration");
        return true;
    }

    @Override
    public boolean endvisit(PHPMethodDeclaration s) throws Exception {
        this.xmlWriter.endTag("PHPMethodDeclaration");
        return true;
    }

    @Override
    public boolean endvisit(PostfixExpression s) throws Exception {
        this.xmlWriter.endTag("PostfixExpression");
        return true;
    }

    @Override
    public boolean endvisit(PrefixExpression s) throws Exception {
        this.xmlWriter.endTag("PrefixExpression");
        return true;
    }

    @Override
    public boolean endvisit(Quote s) throws Exception {
        this.xmlWriter.endTag("Quote");
        return true;
    }

    @Override
    public boolean endvisit(ReferenceExpression s) throws Exception {
        this.xmlWriter.endTag("ReferenceExpression");
        return true;
    }

    @Override
    public boolean endvisit(ReflectionArrayVariableReference s) throws Exception {
        this.xmlWriter.endTag("ReflectionArrayVariableReference");
        return true;
    }

    @Override
    public boolean endvisit(ReflectionCallExpression s) throws Exception {
        this.xmlWriter.endTag("ReflectionCallExpression");
        return true;
    }

    @Override
    public boolean endvisit(ReflectionStaticMethodInvocation s) throws Exception {
        this.xmlWriter.endTag("ReflectionStaticMethodInvocation");
        return true;
    }

    @Override
    public boolean endvisit(ReflectionVariableReference s) throws Exception {
        this.xmlWriter.endTag("ReflectionVariableReference");
        return true;
    }

    @Override
    public boolean endvisit(ReturnStatement s) throws Exception {
        this.xmlWriter.endTag("ReturnStatement");
        return true;
    }

    @Override
    public boolean endvisit(ReturnType s) throws Exception {
        this.xmlWriter.endTag("ReturnType");
        return true;
    }

    @Override
    public boolean endvisit(YieldExpression s) throws Exception {
        this.xmlWriter.endTag("YieldExpression");
        return true;
    }

    @Override
    public boolean endvisit(Scalar s) throws Exception {
        this.xmlWriter.endTag("Scalar");
        return true;
    }

    @Override
    public boolean endvisit(SimpleReference s) throws Exception {
        this.xmlWriter.endTag("SimpleReference");
        return true;
    }

    @Override
    public boolean endvisit(StaticConstantAccess s) throws Exception {
        this.xmlWriter.endTag("StaticConstantAccess");
        return true;
    }

    @Override
    public boolean endvisit(StaticDispatch s) throws Exception {
        this.xmlWriter.endTag("StaticDispatch");
        return true;
    }

    @Override
    public boolean endvisit(StaticFieldAccess s) throws Exception {
        this.xmlWriter.endTag("StaticFieldAccess");
        return true;
    }

    @Override
    public boolean endvisit(StaticMethodInvocation s) throws Exception {
        this.xmlWriter.endTag("StaticMethodInvocation");
        return true;
    }

    @Override
    public boolean endvisit(StaticStatement s) throws Exception {
        this.xmlWriter.endTag("StaticStatement");
        return true;
    }

    @Override
    public boolean endvisit(SwitchCase s) throws Exception {
        this.xmlWriter.endTag("SwitchCase");
        return true;
    }

    @Override
    public boolean endvisit(SwitchStatement s) throws Exception {
        this.xmlWriter.endTag("SwitchStatement");
        return true;
    }

    @Override
    public boolean endvisit(ThrowStatement s) throws Exception {
        this.xmlWriter.endTag("ThrowStatement");
        return true;
    }

    @Override
    public boolean endvisit(TryStatement s) throws Exception {
        this.xmlWriter.endTag("TryStatement");
        return true;
    }

    @Override
    public boolean endvisit(TypeReference s) throws Exception {
        this.xmlWriter.endTag("TypeReference");
        return true;
    }

    @Override
    public boolean endvisit(FullyQualifiedReference s) throws Exception {
        this.xmlWriter.endTag("FullyQualifiedReference");
        return true;
    }

    @Override
    public boolean endvisit(NamespaceReference s) throws Exception {
        this.xmlWriter.endTag("NamespaceReference");
        return true;
    }

    @Override
    public boolean endvisit(UnaryOperation s) throws Exception {
        this.xmlWriter.endTag("UnaryOperation");
        return true;
    }

    @Override
    public boolean endvisit(VariableReference s) throws Exception {
        this.xmlWriter.endTag("VariableReference");
        return true;
    }

    @Override
    public boolean endvisit(WhileStatement s) throws Exception {
        this.xmlWriter.endTag("WhileStatement");
        return true;
    }

    public boolean endvisit(ModuleDeclaration s) throws Exception {
        List<ASTError> errors = ((PHPModuleDeclaration)s).getErrors();
        if (!errors.isEmpty()) {
            this.xmlWriter.startTag("Errors", null);
            for (ASTError error : errors) {
                error.traverse(this);
            }
            this.xmlWriter.endTag("Errors");
        }
        this.xmlWriter.endTag("ModuleDeclaration");
        return true;
    }

    @Override
    public boolean endvisit(NamespaceDeclaration s) throws Exception {
        this.xmlWriter.endTag("NamespaceDeclaration");
        return true;
    }

    @Override
    public boolean endvisit(GotoLabel s) throws Exception {
        this.xmlWriter.endTag("GotoLabel");
        return true;
    }

    @Override
    public boolean endvisit(GotoStatement s) throws Exception {
        this.xmlWriter.endTag("GotoStatement");
        return true;
    }

    @Override
    public boolean endvisit(LambdaFunctionDeclaration s) throws Exception {
        this.xmlWriter.endTag("LambdaFunctionDeclaration");
        return true;
    }

    @Override
    public boolean endvisit(AnonymousClassDeclaration s) throws Exception {
        this.xmlWriter.endTag("AnonymousClassDeclaration");
        return true;
    }

    @Override
    public boolean visit(ArrayCreation s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ArrayCreation", parameters);
        return true;
    }

    @Override
    public boolean visit(ArrayElement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ArrayElement", parameters);
        return true;
    }

    @Override
    public boolean visit(ArrayVariableReference s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("type", ArrayVariableReference.getArrayType(s.getArrayType()));
        parameters.put("name", s.getName());
        this.xmlWriter.startTag("ArrayVariableReference", parameters);
        return true;
    }

    @Override
    public boolean visit(Assignment s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("operator", s.getOperator());
        this.xmlWriter.startTag("Assignment", parameters);
        return true;
    }

    @Override
    public boolean visit(ASTError s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ASTError", parameters);
        return true;
    }

    @Override
    public boolean visit(BackTickExpression s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("BackTickExpression", parameters);
        return true;
    }

    @Override
    public boolean visit(BreakStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("BreakStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(CastExpression s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("type", CastExpression.getCastType(s.getCastType()));
        this.xmlWriter.startTag("CastExpression", parameters);
        return true;
    }

    @Override
    public boolean visit(CatchClause s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("CatchClause", parameters);
        return true;
    }

    @Override
    public boolean visit(FinallyClause s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("FinallyClause", parameters);
        return true;
    }

    @Override
    public boolean visit(ConstantDeclaration s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ConstantDeclaration", parameters);
        return true;
    }

    @Override
    public boolean visit(ClassDeclaration s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("name", s.getName());
        this.xmlWriter.startTag("ClassDeclaration", parameters);
        return true;
    }

    @Override
    public boolean visit(ClassInstanceCreation s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ClassInstanceCreation", parameters);
        return true;
    }

    @Override
    public boolean visit(CloneExpression s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("CloneExpression", parameters);
        return true;
    }

    @Override
    public boolean visit(Comment s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters(s);
        parameters.put("type", Comment.getCommentType(s.getCommentType()));
        this.xmlWriter.startTag("Comment", parameters);
        return true;
    }

    @Override
    public boolean visit(ConditionalExpression s) throws Exception {
        Expression ifTrue;
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("operatorType", String.valueOf(s.getOperatorType()));
        this.xmlWriter.startTag("ConditionalExpression", parameters);
        this.xmlWriter.startTag("Condition", new HashMap());
        s.getCondition().traverse((ASTVisitor)this);
        this.xmlWriter.endTag("Condition");
        if (s.getOperatorType() == 0) {
            Expression falseExp;
            Expression ifTrue2 = s.getIfTrue();
            if (ifTrue2 != null) {
                this.xmlWriter.startTag("IfTrue", new HashMap());
                ifTrue2.traverse((ASTVisitor)this);
                this.xmlWriter.endTag("IfTrue");
            }
            if ((falseExp = s.getIfFalse()) != null) {
                this.xmlWriter.startTag("IfFalse", new HashMap());
                falseExp.traverse((ASTVisitor)this);
                this.xmlWriter.endTag("IfFalse");
            }
        } else if (s.getOperatorType() == 1 && (ifTrue = s.getIfTrue()) != null) {
            this.xmlWriter.startTag("IfNull", new HashMap());
            ifTrue.traverse((ASTVisitor)this);
            this.xmlWriter.endTag("IfNull");
        }
        return false;
    }

    @Override
    public boolean visit(ConstantReference s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("name", s.getName());
        this.xmlWriter.startTag("ConstantReference", parameters);
        return true;
    }

    @Override
    public boolean visit(ContinueStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ContinueStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(DeclareStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("DeclareStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(Dispatch s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("Dispatch", parameters);
        return true;
    }

    @Override
    public boolean visit(DoStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("DoStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(EchoStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("EchoStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(EmptyStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("EmptyStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(ExpressionStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ExpressionStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(FieldAccess s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("FieldAccess", parameters);
        return true;
    }

    @Override
    public boolean visit(ForEachStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ForEachStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(FormalParameter s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("isMandatory", Boolean.toString(s.isMandatory()));
        if (s.isVariadic()) {
            parameters.put("isVariadic", Boolean.toString(s.isVariadic()));
        }
        this.xmlWriter.startTag("FormalParameter", parameters);
        return true;
    }

    @Override
    public boolean visit(FormalParameterByReference s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("FormalParameterByReference", parameters);
        return true;
    }

    @Override
    public boolean visit(ForStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ForStatement", parameters);
        this.xmlWriter.startTag("Initializations", new HashMap());
        for (Expression expression : s.getInitializations()) {
            expression.traverse((ASTVisitor)this);
        }
        this.xmlWriter.endTag("Initializations");
        this.xmlWriter.startTag("Conditions", new HashMap());
        for (Expression expression : s.getConditions()) {
            expression.traverse((ASTVisitor)this);
        }
        this.xmlWriter.endTag("Conditions");
        this.xmlWriter.startTag("Increasements", new HashMap());
        for (Expression expression : s.getIncreasements()) {
            expression.traverse((ASTVisitor)this);
        }
        this.xmlWriter.endTag("Increasements");
        s.getAction().traverse((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(GlobalStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("GlobalStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(IfStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("IfStatement", parameters);
        this.xmlWriter.startTag("Condition", new HashMap());
        s.getCondition().traverse((ASTVisitor)this);
        this.xmlWriter.endTag("Condition");
        this.xmlWriter.startTag("TrueStatement", new HashMap());
        s.getTrueStatement().traverse((ASTVisitor)this);
        this.xmlWriter.endTag("TrueStatement");
        Statement falseStatement = s.getFalseStatement();
        if (falseStatement != null) {
            this.xmlWriter.startTag("FalseStatement", new HashMap());
            falseStatement.traverse((ASTVisitor)this);
            this.xmlWriter.endTag("FalseStatement");
        }
        return false;
    }

    @Override
    public boolean visit(IgnoreError s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("IgnoreError", parameters);
        return true;
    }

    @Override
    public boolean visit(Include s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("type", s.getType());
        this.xmlWriter.startTag("Include", parameters);
        return true;
    }

    @Override
    public boolean visit(InfixExpression s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("operator", s.getOperator());
        this.xmlWriter.startTag("InfixExpression", parameters);
        return true;
    }

    @Override
    public boolean visit(InstanceOfExpression s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("InstanceOfExpression", parameters);
        return true;
    }

    @Override
    public boolean visit(InterfaceDeclaration s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("name", s.getName());
        this.xmlWriter.startTag("InterfaceDeclaration", parameters);
        return true;
    }

    @Override
    public boolean visit(ListVariable s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ListVariable", parameters);
        return true;
    }

    @Override
    public boolean visit(PHPCallArgumentsList s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("PHPCallArgumentsList", parameters);
        return true;
    }

    @Override
    public boolean visit(PHPCallExpression s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("PHPCallExpression", parameters);
        return true;
    }

    @Override
    public boolean visit(PHPDocBlock s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters(s);
        parameters.put("shortDescription", s.getShortDescription());
        this.xmlWriter.startTag("PHPDocBlock", parameters);
        return true;
    }

    @Override
    public boolean visit(PHPDocTag s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters(s);
        parameters.put("tagKind", s.getTagKind().getName());
        parameters.put("matchedTag", s.getMatchedTag());
        parameters.put("tagText", s.getTagText().getValue());
        parameters.put("value", s.getValue());
        this.xmlWriter.startTag("PHPDocTag", parameters);
        return true;
    }

    @Override
    public boolean visit(PHPFieldDeclaration s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("PHPFieldDeclaration", parameters);
        return true;
    }

    @Override
    public boolean visit(PHPMethodDeclaration s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("name", s.getName());
        this.xmlWriter.startTag("PHPMethodDeclaration", parameters);
        return true;
    }

    @Override
    public boolean visit(PostfixExpression s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("operator", s.getOperator());
        this.xmlWriter.startTag("PostfixExpression", parameters);
        return true;
    }

    @Override
    public boolean visit(PrefixExpression s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("operator", s.getOperator());
        this.xmlWriter.startTag("PrefixExpression", parameters);
        return true;
    }

    @Override
    public boolean visit(Quote s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("type", Quote.getType(s.getQuoteType()));
        this.xmlWriter.startTag("Quote", parameters);
        return true;
    }

    @Override
    public boolean visit(ReferenceExpression s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ReferenceExpression", parameters);
        return true;
    }

    @Override
    public boolean visit(ReflectionArrayVariableReference s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ReflectionArrayVariableReference", parameters);
        return true;
    }

    @Override
    public boolean visit(ReflectionCallExpression s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ReflectionCallExpression", parameters);
        return true;
    }

    @Override
    public boolean visit(ReflectionStaticMethodInvocation s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ReflectionStaticMethodInvocation", parameters);
        return true;
    }

    @Override
    public boolean visit(ReflectionVariableReference s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ReflectionVariableReference", parameters);
        return true;
    }

    @Override
    public boolean visit(ReturnStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ReturnStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(ReturnType s) throws Exception {
        this.xmlWriter.startTag("ReturnType", null);
        return true;
    }

    @Override
    public boolean visit(YieldExpression s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        if (s.getOperatorType() != 0) {
            parameters.put("operator", String.valueOf(s.getOperatorType()));
        }
        this.xmlWriter.startTag("YieldExpression", parameters);
        return true;
    }

    @Override
    public boolean visit(Scalar s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("type", s.getType());
        parameters.put("value", s.getValue());
        this.xmlWriter.startTag("Scalar", parameters);
        return true;
    }

    @Override
    public boolean visit(SimpleReference s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("name", s.getName());
        this.xmlWriter.startTag("SimpleReference", parameters);
        return true;
    }

    @Override
    public boolean visit(StaticConstantAccess s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("StaticConstantAccess", parameters);
        return true;
    }

    @Override
    public boolean visit(StaticDispatch s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("StaticDispatch", parameters);
        return true;
    }

    @Override
    public boolean visit(StaticFieldAccess s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("StaticFieldAccess", parameters);
        return true;
    }

    @Override
    public boolean visit(StaticMethodInvocation s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("StaticMethodInvocation", parameters);
        return true;
    }

    @Override
    public boolean visit(StaticStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("StaticStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(SwitchCase s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("SwitchCase", parameters);
        return true;
    }

    @Override
    public boolean visit(SwitchStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("SwitchStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(ThrowStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ThrowStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(TryStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("TryStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(TypeReference s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("name", s.getName());
        this.xmlWriter.startTag("TypeReference", parameters);
        return true;
    }

    @Override
    public boolean visit(FullyQualifiedReference s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("name", s.getFullyQualifiedName());
        if (s.isNullable()) {
            parameters.put("nullable", Boolean.toString(s.isNullable()));
        }
        this.xmlWriter.startTag("FullyQualifiedReference", parameters);
        return true;
    }

    @Override
    public boolean visit(NamespaceReference s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("name", s.getName());
        parameters.put("global", Boolean.toString(s.isGlobal()));
        parameters.put("local", Boolean.toString(s.isLocal()));
        this.xmlWriter.startTag("NamespaceReference", parameters);
        return true;
    }

    @Override
    public boolean visit(UnaryOperation s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("operator", s.getOperator());
        this.xmlWriter.startTag("UnaryOperation", parameters);
        return true;
    }

    @Override
    public boolean visit(VariableReference s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("name", s.getName());
        this.xmlWriter.startTag("VariableReference", parameters);
        return true;
    }

    @Override
    public boolean visit(WhileStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("WhileStatement", parameters);
        return true;
    }

    public boolean visit(ModuleDeclaration s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("ModuleDeclaration", parameters);
        return true;
    }

    @Override
    public boolean visit(NamespaceDeclaration s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("name", s.getName());
        this.xmlWriter.startTag("NamespaceDeclaration", parameters);
        return true;
    }

    @Override
    public boolean visit(UseStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        if (s.getStatementType() != 0) {
            parameters.put("statementType", String.valueOf(s.getStatementType()));
        }
        this.xmlWriter.startTag("UseStatement", parameters);
        if (s.getNamespace() != null) {
            this.xmlWriter.startTag("Namespace", new HashMap());
            s.getNamespace().traverse(this);
            this.xmlWriter.endTag("Namespace");
        }
        this.xmlWriter.startTag("Parts", new HashMap());
        for (UsePart p : s.getParts()) {
            p.traverse(this);
        }
        this.xmlWriter.endTag("Parts");
        this.xmlWriter.endTag("UseStatement");
        return false;
    }

    @Override
    public boolean visit(UsePart s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters(s);
        if (s.getStatementType() != 0) {
            parameters.put("statementType", String.valueOf(s.getStatementType()));
        }
        this.xmlWriter.startTag("UsePart", parameters);
        s.getNamespace().traverse(this);
        if (s.getAlias() != null) {
            s.getAlias().traverse((ASTVisitor)this);
        }
        this.xmlWriter.endTag("UsePart");
        return false;
    }

    @Override
    public boolean visit(GotoLabel s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("label", s.getLabel());
        this.xmlWriter.startTag("GotoLabel", parameters);
        return true;
    }

    @Override
    public boolean visit(GotoStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("label", s.getLabel());
        this.xmlWriter.startTag("GotoStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(LambdaFunctionDeclaration s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("isReference", Boolean.toString(s.isReference()));
        if (s.isStatic()) {
            parameters.put("isStatic", Boolean.toString(s.isStatic()));
        }
        this.xmlWriter.startTag("LambdaFunctionDeclaration", parameters);
        this.xmlWriter.startTag("Arguments", new HashMap());
        for (FormalParameter p : s.getArguments()) {
            p.traverse(this);
        }
        this.xmlWriter.endTag("Arguments");
        Collection<? extends Expression> lexicalVars = s.getLexicalVars();
        if (lexicalVars != null) {
            this.xmlWriter.startTag("LexicalVars", new HashMap());
            for (Expression expression : lexicalVars) {
                expression.traverse((ASTVisitor)this);
            }
            this.xmlWriter.endTag("LexicalVars");
        }
        if (s.getReturnType() != null) {
            this.xmlWriter.startTag("ReturnType", new HashMap());
            s.getReturnType().traverse((ASTVisitor)this);
            this.xmlWriter.endTag("ReturnType");
        }
        s.getBody().traverse((ASTVisitor)this);
        return false;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("AnonymousClassDeclaration", parameters);
        if (s.getSuperClass() != null) {
            this.xmlWriter.startTag("SuperClass", new HashMap());
            s.getSuperClass().traverse((ASTVisitor)this);
            this.xmlWriter.endTag("SuperClass");
        }
        if (s.getInterfaceList() != null) {
            this.xmlWriter.startTag("Interfaces", new HashMap());
            for (TypeReference interfacee : s.getInterfaceList()) {
                interfacee.traverse((ASTVisitor)this);
            }
            this.xmlWriter.endTag("Interfaces");
        }
        this.xmlWriter.startTag("Body", new HashMap());
        s.getBody().traverse((ASTVisitor)this);
        this.xmlWriter.endTag("Body");
        return false;
    }

    @Override
    public boolean visit(FullyQualifiedTraitMethodReference s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("functionName", s.getFunctionName());
        this.xmlWriter.startTag("FullyQualifiedTraitMethodReference", parameters);
        this.xmlWriter.startTag("className", this.EMPTY_MAP);
        s.getClassName().traverse((ASTVisitor)this);
        this.xmlWriter.endTag("className");
        this.xmlWriter.endTag("FullyQualifiedTraitMethodReference");
        return false;
    }

    @Override
    public boolean visit(TraitAlias s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        if (s.getMethodName() != null) {
            parameters.put("methodName", s.getMethodName().getName());
        }
        this.xmlWriter.startTag("TraitAlias", parameters);
        return true;
    }

    @Override
    public boolean visit(TraitAliasStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("TraitAliasStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(TraitPrecedence s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("TraitPrecedence", parameters);
        return true;
    }

    @Override
    public boolean visit(TraitPrecedenceStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("TraitPrecedenceStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(TraitUseStatement s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        this.xmlWriter.startTag("TraitUseStatement", parameters);
        return true;
    }

    @Override
    public boolean visit(TraitDeclaration s) throws Exception {
        Map<String, String> parameters = this.createInitialParameters((ASTNode)s);
        parameters.put("name", s.getName());
        this.xmlWriter.startTag("TraitDeclaration", parameters);
        return true;
    }

    @Override
    public boolean endvisit(FullyQualifiedTraitMethodReference s) throws Exception {
        this.xmlWriter.endTag("FullyQualifiedTraitMethodReference");
        return false;
    }

    @Override
    public boolean endvisit(TraitAlias s) throws Exception {
        this.xmlWriter.endTag("TraitAlias");
        return false;
    }

    @Override
    public boolean endvisit(TraitAliasStatement s) throws Exception {
        this.xmlWriter.endTag("TraitAliasStatement");
        return false;
    }

    @Override
    public boolean endvisit(TraitPrecedence s) throws Exception {
        this.xmlWriter.endTag("TraitPrecedence");
        return false;
    }

    @Override
    public boolean endvisit(TraitPrecedenceStatement s) throws Exception {
        this.xmlWriter.endTag("TraitPrecedenceStatement");
        return false;
    }

    @Override
    public boolean endvisit(TraitUseStatement s) throws Exception {
        this.xmlWriter.endTag("TraitUseStatement");
        return false;
    }

    @Override
    public boolean endvisit(TraitDeclaration s) throws Exception {
        this.xmlWriter.endTag("TraitDeclaration");
        return false;
    }
}

