/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.lookup.WidgetLookup;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.LaunchConfiguration;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.swt.api.MenuItem;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.YesButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenu;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.hamcrest.Matcher;

public abstract class LaunchConfigurationsDialog {
    private static final Logger log = Logger.getLogger(LaunchConfigurationsDialog.class);

    public abstract String getTitle();

    protected abstract String getMenuItemName();

    public void open() {
        log.info("Open launch configuration dialog");
        ShellMenuItem menu = new ShellMenuItem(new String[]{"Run", this.getMenuItemName()});
        menu.select();
        new DefaultShell(this.getTitle());
    }

    public void select(LaunchConfiguration configuration) {
        log.info("Select launch configuration " + configuration.getType());
        DefaultTreeItem t = new DefaultTreeItem(new String[]{configuration.getType()});
        t.select();
    }

    public void select(LaunchConfiguration configuration, String name) {
        log.info("Select launch configuration " + configuration.getType() + " with name " + name);
        DefaultTreeItem t = new DefaultTreeItem(new String[]{configuration.getType(), name});
        t.select();
        new WaitUntil((WaitCondition)new WidgetIsFound(CLabel.class, new Matcher[]{new WithTextMatcher(name)}), TimePeriod.DEFAULT, false);
    }

    public void create(LaunchConfiguration configuration) {
        log.info("Create new launch configuration " + configuration.getType());
        this.create(configuration, null);
    }

    public void create(LaunchConfiguration configuration, String name) {
        log.info("Create new launch configuration " + configuration.getType() + " with name " + name);
        DefaultTreeItem t = new DefaultTreeItem(new String[]{configuration.getType()});
        t.select();
        new WaitUntil((WaitCondition)new TreeIsSelectedAndHasFocus((TreeItem)t));
        MenuItem newMenuItem = new ContextMenu().getItems().stream().filter(menuItem -> menuItem.getText().equals("New") || menuItem.getText().toLowerCase().equals("new configuration")).findFirst().get();
        if (newMenuItem == null) {
            throw new EclipseLayerException("Cannot create new launch configuration");
        }
        newMenuItem.select();
        if (name != null) {
            configuration.setName(name);
            configuration.apply();
        }
    }

    public void delete(LaunchConfiguration configuration, String name) {
        log.info("Delete launch configuration " + configuration.getType() + " with name " + name);
        DefaultTreeItem t = new DefaultTreeItem(new String[]{configuration.getType(), name});
        t.select();
        new ContextMenuItem(new String[]{"Delete"}).select();
        DefaultShell deleteShell = new DefaultShell("Confirm Launch Configuration Deletion");
        WidgetIsFound deleteButton = new WidgetIsFound(Button.class, (Control)deleteShell.getSWTWidget(), new Matcher[]{new WithMnemonicTextMatcher("Delete")});
        Object button = deleteButton.test() ? new PushButton((ReferencedComposite)deleteShell, "Delete") : new YesButton((ReferencedComposite)deleteShell);
        button.click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)deleteShell));
    }

    public void run() {
        log.info("Run the launch configuration");
        String shellText = new DefaultShell().getText();
        PushButton button = new PushButton("Run");
        button.click();
        new WaitWhile((WaitCondition)new ShellIsAvailable(shellText), TimePeriod.VERY_LONG);
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
    }

    public void close() {
        log.info("Close the launch configuration dialog");
        String shellText = new DefaultShell().getText();
        PushButton button = new PushButton("Close");
        button.click();
        new WaitWhile((WaitCondition)new ShellIsAvailable(shellText));
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    private class TreeIsSelectedAndHasFocus
    extends AbstractWaitCondition {
        private TreeItem item;

        public TreeIsSelectedAndHasFocus(TreeItem item) {
            this.item = item;
        }

        public boolean test() {
            Control focusControl = WidgetLookup.getInstance().getFocusControl();
            if (!(focusControl instanceof Tree)) {
                return false;
            }
            return this.item.isSelected();
        }

        public String description() {
            return "Tree has focus and TreeItem " + this.item.getText() + " is selected";
        }

        public String errorMessageWhile() {
            return "TreeItem '" + this.item.getText() + "' has focus and is selected ";
        }

        public String errorMessageUntil() {
            return "Tree does not has focus or TreeItem '" + this.item.getText() + "' is not selected";
        }
    }
}

