/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICreationTask;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ArrangeConstraint;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.AbstractDNodeCandidate;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.AbstractNodeMappingSpecOperations;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.tools.api.refresh.BestMappingGetter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class CreateDNodeTask
extends AbstractCommandTask
implements ICreationTask {
    private final NodeCreationDescription tool;
    private final ModelAccessor modelAccessor;
    private DragAndDropTarget containerView;
    private Collection<AbstractDNode> createdAbstractDNodes = new ArrayList<AbstractDNode>();
    private final DCommand cmd;

    public CreateDNodeTask(NodeCreationDescription tool, DCommand cmd, ModelAccessor modelAccessor, DragAndDropTarget containerView) {
        this.tool = tool;
        this.cmd = cmd;
        this.modelAccessor = modelAccessor;
        this.containerView = containerView;
    }

    public void execute() {
        if (this.containerView instanceof DSemanticDecorator) {
            DSemanticDecorator containerViewDSemanticDecorator = (DSemanticDecorator)this.containerView;
            EObjectQuery eObjectQuery = new EObjectQuery((EObject)containerViewDSemanticDecorator);
            Session session = eObjectQuery.getSession();
            DSemanticDiagram dSemanticDiagram = (DSemanticDiagram)eObjectQuery.getParentDiagram().get();
            this.createNodes(session, dSemanticDiagram, containerViewDSemanticDecorator);
        }
    }

    private void createNodes(Session session, DSemanticDiagram dSemanticDiagram, DSemanticDecorator containerViewDSemanticDecorator) {
        IInterpreter interpreter = session.getInterpreter();
        DDiagramElementSynchronizer dDiagramElementSynchronizer = new DDiagramElementSynchronizer(dSemanticDiagram, interpreter, this.modelAccessor);
        Collection createdObjects = this.cmd.getCreatedObjects();
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, dSemanticDiagram);
        for (EObject semanticElt : createdObjects) {
            AbstractDNodeCandidate abstractDNodeCandidate;
            AbstractDNode createdAbstractDNode;
            BestMappingGetter bestMappingGetter = new BestMappingGetter(containerViewDSemanticDecorator, semanticElt);
            NodeMapping bestMapping = bestMappingGetter.getBestNodeMapping((Collection<NodeMapping>)this.tool.getNodeMappings());
            if (bestMapping == null || (createdAbstractDNode = dDiagramElementSynchronizer.createNewNode(mappingManager, abstractDNodeCandidate = new AbstractDNodeCandidate(bestMapping, semanticElt, this.containerView, RefreshIdsHolder.getOrCreateHolder((EObject)dSemanticDiagram)), bestMapping.eContainingFeature() == DescriptionPackage.Literals.ABSTRACT_NODE_MAPPING__BORDERED_NODE_MAPPINGS)) == null) continue;
            AbstractNodeMappingSpecOperations.createBorderingNodes(bestMapping, semanticElt, createdAbstractDNode, Collections.emptyList(), dSemanticDiagram);
            if (this.isAutoPinOnCreateEnabled()) {
                createdAbstractDNode.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_LOCATION);
                createdAbstractDNode.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_RATIO);
                createdAbstractDNode.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_SIZE);
            }
            AbstractNodeMappingSpecOperations.setInitialVisibility(createdAbstractDNode, dSemanticDiagram, session);
            this.createdAbstractDNodes.add(createdAbstractDNode);
        }
    }

    public String getLabel() {
        return Messages.CreateDNodeTask_label;
    }

    private boolean isAutoPinOnCreateEnabled() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", SiriusDiagramPreferencesKeys.PREF_AUTO_PIN_ON_CREATE.name(), false, null);
    }

    public Collection<EObject> getCreatedElements() {
        return Collections.emptySet();
    }

    public Collection<EObject> getAffectedElements() {
        return Collections.emptySet();
    }

    public Collection<EObject> getCreatedReferences() {
        return Collections.emptySet();
    }

    public Collection<DRepresentationElement> getCreatedRepresentationElements() {
        return new ArrayList<DRepresentationElement>(this.createdAbstractDNodes);
    }
}

