/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.viewpoint.description.util;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.sirius.business.api.migration.ResourceVersionMismatchDiagnostic;
import org.eclipse.sirius.business.internal.migration.description.VSMExtendedMetaData;
import org.eclipse.sirius.business.internal.migration.description.VSMMigrationService;
import org.eclipse.sirius.business.internal.migration.description.VSMResourceHandler;
import org.eclipse.sirius.business.internal.migration.description.VSMResourceXMILoad;
import org.eclipse.sirius.business.internal.migration.description.VSMVersionSAXParser;
import org.eclipse.sirius.business.internal.migration.description.VSMXMIHelper;
import org.eclipse.sirius.ext.base.Option;
import org.osgi.framework.Version;

public class DescriptionResourceImpl
extends XMIResourceImpl {
    public static final String OPTION_USE_URI_FRAGMENT_AS_ID = "SIRIUS_USE_URI_FRAGMENT_AS_ID";
    private boolean useURIFragmentAsId;

    protected DescriptionResourceImpl(URI uri) {
        super(uri);
    }

    protected XMLHelper createXMLHelper() {
        return new VSMXMIHelper((XMLResource)this);
    }

    protected XMLLoad createXMLLoad(Map<?, ?> options) {
        if (options != null && options.containsKey("RESOURCE_MIGRATION_LOADEDVERSION")) {
            String loadedVersion = null;
            Object mapVersion = options.get("RESOURCE_MIGRATION_LOADEDVERSION");
            if (mapVersion instanceof String) {
                loadedVersion = (String)mapVersion;
            }
            return new VSMResourceXMILoad(loadedVersion, this.createXMLHelper());
        }
        return super.createXMLLoad(options);
    }

    public void setModified(boolean isModified) {
        super.setModified(isModified);
        if (isModified) {
            this.getIDToEObjectMap().clear();
        }
    }

    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded) {
            this.useURIFragmentAsId = Boolean.TRUE.equals(options.get(OPTION_USE_URI_FRAGMENT_AS_ID)) && this.getURI().isPlatformPlugin();
            Resource.Diagnostic migrationMismatchDiagnostic = this.handleMigrationOptions();
            super.load(options);
            if (migrationMismatchDiagnostic != null) {
                this.getErrors().add((Object)migrationMismatchDiagnostic);
            }
        }
    }

    private Resource.Diagnostic handleMigrationOptions() {
        ResourceVersionMismatchDiagnostic migrationMismatchDiagnostic = null;
        VSMVersionSAXParser parser = new VSMVersionSAXParser(this.uri);
        String loadedVersion = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
        boolean migrationIsNeeded = true;
        if (loadedVersion != null) {
            boolean attemptToLoadMoreRecentVSM;
            Version parsedLoadedVersion = Version.parseVersion((String)loadedVersion);
            Version lastMigrationVersion = VSMMigrationService.getInstance().getLastMigrationVersion();
            boolean bl = attemptToLoadMoreRecentVSM = lastMigrationVersion.compareTo(parsedLoadedVersion) < 0;
            if (attemptToLoadMoreRecentVSM) {
                migrationMismatchDiagnostic = new ResourceVersionMismatchDiagnostic(this.uri, parsedLoadedVersion, lastMigrationVersion);
            }
            migrationIsNeeded = VSMMigrationService.getInstance().isMigrationNeeded(parsedLoadedVersion);
        }
        Object versionOption = this.getDefaultLoadOptions().get("RESOURCE_MIGRATION_LOADEDVERSION");
        if (!migrationIsNeeded && versionOption != null) {
            this.removeMigrationMechanism();
        } else if (migrationIsNeeded && (versionOption == null || !versionOption.equals(loadedVersion))) {
            DescriptionResourceImpl.addMigrationOptions(loadedVersion, this.getDefaultLoadOptions(), this.getDefaultSaveOptions());
        }
        return migrationMismatchDiagnostic;
    }

    private void removeMigrationMechanism() {
        this.getDefaultLoadOptions().remove("EXTENDED_META_DATA");
        this.getDefaultLoadOptions().remove("RESOURCE_HANDLER");
        this.getDefaultLoadOptions().remove("RESOURCE_MIGRATION_LOADEDVERSION");
        this.getDefaultSaveOptions().remove("EXTENDED_META_DATA");
        this.getDefaultSaveOptions().remove("RESOURCE_HANDLER");
    }

    public static void addMigrationOptions(String loadedVersion, Map<Object, Object> loadOptions, Map<Object, Object> saveOptions) {
        VSMExtendedMetaData extendedMetaData = new VSMExtendedMetaData(loadedVersion);
        VSMResourceHandler resourceHandler = new VSMResourceHandler(loadedVersion);
        loadOptions.put("EXTENDED_META_DATA", (Object)extendedMetaData);
        loadOptions.put("RESOURCE_HANDLER", (Object)resourceHandler);
        loadOptions.put("RESOURCE_MIGRATION_LOADEDVERSION", loadedVersion);
        saveOptions.put("EXTENDED_META_DATA", (Object)extendedMetaData);
        saveOptions.put("RESOURCE_HANDLER", (Object)resourceHandler);
    }

    public EObject getEObject(String uriFragment) {
        Option<String> optionalRewrittenFragment = VSMMigrationService.getInstance().getNewFragment(uriFragment);
        if (optionalRewrittenFragment.some()) {
            return this.getEObject((String)optionalRewrittenFragment.get());
        }
        if (this.useURIFragmentAsId) {
            return this.getEObjectUsingURIFragmentAsId(uriFragment);
        }
        return super.getEObject(uriFragment);
    }

    private EObject getEObjectUsingURIFragmentAsId(String uriFragment) {
        EObject eObject = null;
        if (this.isLoading) {
            eObject = this.getEObjectAndUpdateIDMap(uriFragment);
        } else {
            eObject = this.getEObjectByID(uriFragment);
            if (eObject == null) {
                eObject = this.getEObjectAndUpdateIDMap(uriFragment);
            }
        }
        return eObject;
    }

    private EObject getEObjectAndUpdateIDMap(String uriFragment) {
        EObject eObject = super.getEObject(uriFragment);
        if (eObject != null) {
            this.setID(eObject, uriFragment);
        }
        return eObject;
    }
}

