/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.profiler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlan;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanExecutor;

public class LocalSearchProfilerAdapter
implements ILocalSearchAdapter {
    private final Map<MatcherReference, List<SearchPlan>> planReference = new HashMap<MatcherReference, List<SearchPlan>>();
    private final Map<ISearchOperation, Integer> successfulOperationCounts = new HashMap<ISearchOperation, Integer>();
    private final Map<ISearchOperation, Integer> failedOperationCounts = new HashMap<ISearchOperation, Integer>();

    @Override
    public void patternMatchingStarted(LocalSearchMatcher lsMatcher) {
        MatcherReference key = new MatcherReference(lsMatcher.getPlanDescriptor().getQuery(), lsMatcher.getPlanDescriptor().getAdornment());
        this.planReference.put(key, lsMatcher.getPlan().stream().map(SearchPlanExecutor::getSearchPlan).collect(Collectors.toList()));
    }

    @Override
    public void operationExecuted(SearchPlan plan, ISearchOperation operation, MatchingFrame frame, boolean isSuccessful) {
        Map<ISearchOperation, Integer> counts = isSuccessful ? this.successfulOperationCounts : this.failedOperationCounts;
        counts.merge(operation, 1, (k, v) -> v + 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<MatcherReference, List<SearchPlan>> entry : this.planReference.entrySet()) {
            sb.append(entry.getKey());
            sb.append("\n");
            sb.append(entry.getValue());
            List<SearchPlan> bodies = entry.getValue();
            sb.append("{\n");
            int i = 0;
            while (i < bodies.size()) {
                sb.append("\tbody #");
                sb.append(i);
                sb.append("(\n");
                for (ISearchOperation operation : bodies.get(i).getOperations()) {
                    int successCount = this.successfulOperationCounts.computeIfAbsent(operation, op -> 0);
                    int failCount = this.failedOperationCounts.computeIfAbsent(operation, op -> 0);
                    sb.append("\t\t");
                    sb.append(successCount);
                    sb.append("\t");
                    sb.append(failCount);
                    sb.append("\t");
                    sb.append(successCount + failCount);
                    sb.append("\t");
                    sb.append(operation);
                    sb.append("\n");
                }
                sb.append("\t)\n");
                ++i;
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

