/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.queries;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQueries;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public class PDisjunction {
    private Set<PBody> bodies;
    private PQuery query;

    public PDisjunction(Set<PBody> bodies) {
        this(bodies.iterator().next().getPattern(), bodies);
    }

    public PDisjunction(PQuery query, Set<PBody> bodies) {
        this.query = query;
        this.bodies = Collections.unmodifiableSet(new HashSet<PBody>(bodies));
        this.bodies.forEach(body -> body.setContainerDisjunction(this));
    }

    public Set<PBody> getBodies() {
        return this.bodies;
    }

    public PQuery getQuery() {
        return this.query;
    }

    public Set<PQuery> getDirectReferredQueries() {
        return this.getBodies().stream().flatMap(PQueries.directlyReferencedQueriesFunction()).collect(Collectors.toSet());
    }

    public Set<PQuery> getAllReferredQueries() {
        HashSet<PQuery> processedQueries = new HashSet<PQuery>();
        processedQueries.add(this.getQuery());
        Set<PQuery> foundQueries = this.getDirectReferredQueries();
        HashSet<PQuery> newQueries = new HashSet<PQuery>(foundQueries);
        while (!processedQueries.containsAll(newQueries)) {
            PQuery query = (PQuery)newQueries.iterator().next();
            processedQueries.add(query);
            newQueries.remove(query);
            Set<PQuery> referred = query.getDirectReferredQueries();
            referred.removeAll(processedQueries);
            foundQueries.addAll(referred);
            newQueries.addAll(referred);
        }
        return foundQueries;
    }

    public boolean isMutable() {
        for (PBody body : this.bodies) {
            if (body.isMutable()) continue;
            return false;
        }
        return true;
    }
}

