/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.views.traceability.generic;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.viatra.query.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.transformation.views.traceability.patterns.Trace;

public class GenericReferencedPQuery
extends BaseGeneratedEMFPQuery {
    private static final String DEFAULT_SUBPACKAGE = "ref";
    private static final String DEFAULT_POSTFIX = "<referenced>";
    private List<PParameter> parameters;
    private Multimap<PParameter, PParameter> traceSources;
    private Map<PParameter, String> traceIds;
    protected int singleUseCounter = 0;
    private String traceabilityId;
    private PQuery baseQuery;

    public GenericReferencedPQuery(GenericReferencedPQuery referencedQuery) {
        this.baseQuery = referencedQuery.baseQuery;
        this.parameters = Lists.newArrayList(referencedQuery.parameters);
        this.traceSources = referencedQuery.traceSources;
        this.traceIds = referencedQuery.traceIds;
        this.traceabilityId = referencedQuery.traceabilityId;
    }

    public GenericReferencedPQuery(PQuery baseQuery, Multimap<PParameter, PParameter> traceSources, Map<PParameter, String> traceIds, String traceabilityId) {
        this.baseQuery = baseQuery;
        this.parameters = Lists.newArrayList((Iterable)baseQuery.getParameters());
        this.parameters.addAll(traceSources.keySet());
        this.traceSources = traceSources;
        this.traceIds = traceIds;
        this.traceabilityId = traceabilityId;
        this.ensureInitialized();
    }

    public String getFullyQualifiedName() {
        String fqn = this.baseQuery.getFullyQualifiedName();
        int i = fqn.lastIndexOf(46);
        if (i == -1) {
            return String.format("%s.%s%s<%s>", DEFAULT_SUBPACKAGE, fqn, DEFAULT_POSTFIX, this.traceabilityId);
        }
        String prefix = fqn.substring(0, i);
        String name = fqn.substring(i);
        return String.format("%s.%s%s%s<%s>", prefix, DEFAULT_SUBPACKAGE, name, DEFAULT_POSTFIX, this.traceabilityId);
    }

    public List<PParameter> getParameters() {
        return this.parameters;
    }

    protected Set<PBody> doGetContainedBodies() {
        PBody body = new PBody((PQuery)this);
        List originalParams = this.baseQuery.getParameters();
        ArrayList newVariables = Lists.newArrayList();
        ArrayList symbolicParameters = Lists.newArrayList();
        for (PParameter originalParam : originalParams) {
            PVariable var_param = body.getOrCreateVariableByName(originalParam.getName());
            symbolicParameters.add(new ExportedParameter(body, var_param, originalParam));
            newVariables.add(var_param);
        }
        body.setSymbolicParameters((List)symbolicParameters);
        new PositivePatternCall(body, Tuples.flatTupleOf((Object[])newVariables.toArray()), this.baseQuery);
        this.insertTraceCall(body);
        return Collections.singleton(body);
    }

    private void insertTraceCall(PBody body) {
        for (PParameter pParameter : this.traceSources.keySet()) {
            this.insertTraceCall(body, pParameter);
        }
    }

    private void insertTraceCall(PBody body, PParameter pTarget) {
        PVariable var_target = body.getOrCreateVariableByName(pTarget.getName());
        body.getSymbolicParameters().add(new ExportedParameter(body, var_target, pTarget));
        PVariable var_id = null;
        var_id = this.traceIds.containsKey(pTarget) ? body.newConstantVariable((Object)this.traceIds.get(pTarget)) : body.getOrCreateVariableByName("_<" + ++this.singleUseCounter + ">");
        for (PParameter pSource : this.traceSources.get((Object)pTarget)) {
            PVariable var_source = body.getOrCreateVariableByName(pSource.getName());
            PVariable var_ = body.getOrCreateVariableByName("_<" + ++this.singleUseCounter + ">");
            PVariable var_trace1 = body.getOrCreateVariableByName("_<" + ++this.singleUseCounter + ">");
            PVariable var_trace2 = body.getOrCreateVariableByName("_<" + ++this.singleUseCounter + ">");
            PVariable var_traceability = body.newConstantVariable((Object)this.traceabilityId);
            new PositivePatternCall(body, Tuples.wideFlatTupleOf((Object[])new Object[]{var_source, var_id, var_target, var_trace1, var_traceability}), Trace.instance().getInternalQueryRepresentation());
            new NegativePatternCall(body, Tuples.wideFlatTupleOf((Object[])new Object[]{var_target, var_id, var_, var_trace2, var_traceability}), Trace.instance().getInternalQueryRepresentation());
        }
        if (pTarget.getTypeName() != null) {
            String[] type = pTarget.getTypeName().split(Pattern.quote("||"));
            new TypeConstraint(body, Tuples.staticArityFlatTupleOf((Object)var_target), GenericReferencedPQuery.toInputKey(this.getClassifierLiteral(type[0], type[1])));
        }
    }

    private static IInputKey toInputKey(EClassifier classifierLiteral) {
        if (classifierLiteral instanceof EClass) {
            return new EClassTransitiveInstancesKey((EClass)classifierLiteral);
        }
        if (classifierLiteral instanceof EDataType) {
            return new EDataTypeInSlotsKey((EDataType)classifierLiteral);
        }
        return null;
    }

    protected EClassifier getClassifierLiteral(String packageUri, String classifierName) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(packageUri);
        Preconditions.checkState((ePackage != null ? 1 : 0) != 0, (String)"EPackage %s not found in EPackage Registry.", (Object[])new Object[]{packageUri});
        EClassifier literal = ePackage.getEClassifier(classifierName);
        Preconditions.checkState((literal != null ? 1 : 0) != 0, (String)"Classifier %s not found in EPackage %s", (Object[])new Object[]{classifierName, packageUri});
        return literal;
    }

    protected Collection<String> getBaseParameters() {
        return this.baseQuery.getParameterNames();
    }

    public Multimap<PParameter, PParameter> getReferenceSources() {
        return this.traceSources;
    }

    public final Set<PParameter> getReferenceParameters() {
        return this.traceSources.keySet();
    }

    public String getTraceabilityId() {
        return this.traceabilityId;
    }
}

