/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.part;

import org.eclipse.wb.core.gef.policy.TabOrderContainerEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.LayoutPolicyUtils;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.policies.IRefreshableEditPolicy;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.part.ControlEditPart;
import org.eclipse.wb.internal.swt.gef.policy.layout.DefaultLayoutEditPolicy;
import org.eclipse.wb.internal.swt.gef.policy.layout.DropLayoutEditPolicy;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;

public class CompositeEditPart
extends ControlEditPart {
    private final CompositeInfo m_composite;
    private LayoutInfo m_currentLayout;

    public CompositeEditPart(CompositeInfo composite) {
        super(composite);
        this.m_composite = composite;
    }

    protected void drawCustomBorder(Figure figure, Graphics graphics) {
        try {
            if (this.m_composite.shouldDrawDotsBorder()) {
                graphics.setForegroundColor(IColorConstants.gray);
                graphics.setLineStyle(3);
                Rectangle area = figure.getClientArea();
                graphics.drawRectangle(0, 0, area.width - 1, area.height - 1);
            }
        }
        catch (Throwable throwable) {}
    }

    protected void addChildVisual(EditPart childPart, int index) {
        super.addChildVisual(childPart, this.getFigure().getChildren().size() - index);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        if (this.m_composite.hasLayout()) {
            this.installEditPolicy((EditPolicy)new DropLayoutEditPolicy(this.m_composite));
        }
        this.installEditPolicy("tab container role", (EditPolicy)new TabOrderContainerEditPolicy());
    }

    protected void refreshEditPolicies() {
        super.refreshEditPolicies();
        if (this.m_composite.hasLayout()) {
            LayoutInfo layout = this.m_composite.getLayout();
            if (layout != this.m_currentLayout) {
                this.m_currentLayout = layout;
                LayoutEditPolicy policy = LayoutPolicyUtils.createLayoutEditPolicy((EditPart)this, (Object)layout);
                if (policy == null) {
                    policy = new DefaultLayoutEditPolicy();
                }
                this.installEditPolicy("LayoutEditPolicy", (EditPolicy)policy);
            } else {
                EditPolicy policy = this.getEditPolicy("LayoutEditPolicy");
                if (policy instanceof IRefreshableEditPolicy) {
                    ((IRefreshableEditPolicy)policy).refreshEditPolicy();
                }
            }
        }
    }
}

