/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.update.preferences;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class PreferenceController {
    static IConfigurationManager manager = (IConfigurationManager)ZigguratInject.make(IConfigurationManager.class);
    private static int DEFAULT_REFRESH_TIME = 300;
    public static String PREF_IMPACT_ANALYSIS = "IMPACT_ANALYSIS";
    public static String PREF_IS_IMPACT_ANALYSIS = "IS_IMPACT_ANALYSIS";
    public static String PREF_REFRESH_TIME = "REFRESH_TIME";

    public static String getPathForImpactAnalysis() {
        return (String)PreferenceController.getPref(PREF_IMPACT_ANALYSIS);
    }

    public static boolean isImpactAnalysis() {
        Boolean res = (Boolean)PreferenceController.getPref(PREF_IS_IMPACT_ANALYSIS);
        if (res != null) {
            return res;
        }
        return false;
    }

    public static int getRefreshTime() {
        Integer val = (Integer)PreferenceController.getPref(PREF_REFRESH_TIME);
        if (val != null) {
            return val;
        }
        return DEFAULT_REFRESH_TIME;
    }

    public static <T> T getPref(String key) {
        Map map = manager.getSimpleConfiguration(null, null, "org.polarsys.reqcycle.repository.connector.update", true);
        if (map != null) {
            return (T)map.get(key);
        }
        return null;
    }

    public static void savePref(String key, Object value) {
        Map map = manager.getSimpleConfiguration(null, IConfigurationManager.Scope.WORKSPACE, "org.polarsys.reqcycle.repository.connector.update", true);
        if (map == null) {
            map = Maps.newHashMap();
        }
        map.put(key, value);
        try {
            manager.saveSimpleConfiguration(map, null, null, "org.polarsys.reqcycle.repository.connector.update");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

