/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.ui;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.types.ITraceabilityAttributesManager;
import org.polarsys.reqcycle.traceability.ui.views.LinkPropertyDescriptor;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class LinkPropertySource
implements IPropertySource2 {
    private ITraceabilityAttributesManager attributesManager = (ITraceabilityAttributesManager)ZigguratInject.make(ITraceabilityAttributesManager.class);
    private Callable<?> callback;
    Map<String, ITraceabilityAttributesManager.EditableAttribute> attributes = null;

    public LinkPropertySource(Link link, Callable<?> callback) {
        this.attributes = Maps.uniqueIndex((Iterable)this.attributesManager.getAttributes(link.getId()), (Function)new Function<ITraceabilityAttributesManager.EditableAttribute, String>(){

            public String apply(ITraceabilityAttributesManager.EditableAttribute arg0) {
                return arg0.getName();
            }
        });
        this.callback = callback;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList editableAttributes = Lists.newArrayList(this.attributes.values());
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[editableAttributes.size()];
        int i = 0;
        while (i < editableAttributes.size()) {
            descriptors[i] = new LinkPropertyDescriptor((ITraceabilityAttributesManager.EditableAttribute)editableAttributes.get(i));
            ++i;
        }
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        ITraceabilityAttributesManager.EditableAttribute att = this.attributes.get(id);
        return att.getValue();
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        ITraceabilityAttributesManager.EditableAttribute att = this.attributes.get(id);
        att.setValue(value);
        if (this.callback != null) {
            try {
                this.callback.call();
            }
            catch (Exception exception) {}
        }
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }
}

