/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.typesmodel.handler;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.ini4j.Profile;
import org.ini4j.Wini;
import org.polarsys.reqcycle.inittypes.inittypes.Attribute;
import org.polarsys.reqcycle.inittypes.inittypes.FileType;
import org.polarsys.reqcycle.inittypes.inittypes.InittypesFactory;
import org.polarsys.reqcycle.inittypes.inittypes.Regex;
import org.polarsys.reqcycle.inittypes.inittypes.Requirement;
import org.polarsys.reqcycle.inittypes.inittypes.Type;
import org.polarsys.reqcycle.inittypes.inittypes.TypeModel;
import org.polarsys.reqcycle.typesmodel.Activator;
import org.polarsys.reqcycle.typesmodel.Messages;
import org.topcased.windows.ini.actions.IniFileParser;

public class IniManagerRegistry
implements IResourceVisitor,
IResourceDeltaVisitor {
    private TypeModel typeModel = InittypesFactory.eINSTANCE.createTypeModel();
    private static Pattern requirementRegexPattern = Pattern.compile(Messages.RequirementRegex);
    private static Pattern requirementNamePattern = Pattern.compile(Messages.RequirementName);
    private static Pattern attributeRegexPattern = Pattern.compile(Messages.AttributeRegex);
    private static Pattern attributeNamePattern = Pattern.compile(Messages.AttributeName);

    public boolean visit(IResource resource) throws CoreException {
        if (resource.isAccessible()) {
            this.visit(resource, kind.ADD);
            return true;
        }
        return !(resource instanceof IProject);
    }

    public void visit(IResource resource, kind type) {
        if (Messages.Types.equals(resource.getFileExtension()) && resource instanceof IFile) {
            switch (type) {
                case ADD: {
                    if (!this.fileAdded((IFile)resource)) break;
                    Activator.getDefault().debug(String.valueOf(Messages.NewFile) + resource.toString());
                    break;
                }
                case DELETE: {
                    if (!this.fileDeleted((IFile)resource)) break;
                    Activator.getDefault().debug(String.valueOf(Messages.DeletedFile) + resource.toString());
                    break;
                }
                case MODIFY: {
                    this.fileUpdated((IFile)resource);
                    Activator.getDefault().debug(String.valueOf(Messages.ModifiedFile) + resource.toString());
                    break;
                }
            }
        }
    }

    private boolean fileAdded(IFile resource) {
        FileType fileType = IniManagerRegistry.parseTypesFile(resource);
        if (fileType != null) {
            this.typeModel.getFileTypes().add((Object)fileType);
        }
        return true;
    }

    public static FileType parseTypesFile(IFile resource) {
        FileType fileType = InittypesFactory.eINSTANCE.createFileType();
        fileType.setName(IniManagerRegistry.getMethodName(resource));
        IniFileParser parser = new IniFileParser(resource);
        String[] types = parser.getTypes();
        if (types == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.reqcycle.typesmodel", "the element : " + types + " was ignored because it's empty"));
            return null;
        }
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            Profile.Section section = parser.getElements(type);
            if (section != null) {
                Type TypeInDoc = InittypesFactory.eINSTANCE.createType();
                TypeInDoc.setName(type);
                for (Map.Entry element : section.entrySet()) {
                    if (!requirementNamePattern.matcher((CharSequence)element.getKey()).matches()) continue;
                    String elementId = ((String)element.getKey()).replace("Name", "");
                    if (element.getValue() == null || ((String)element.getValue()).length() == 0) {
                        Activator.getDefault().getLog().log((IStatus)new Status(2, "org.polarsys.reqcycle.typesmodel", "the element : " + (String)element.getKey() + "=" + (String)element.getValue() + " was ignored because it's empty"));
                    }
                    Requirement requirement = InittypesFactory.eINSTANCE.createRequirement();
                    requirement.setNameReq((String)element.getValue());
                    for (Map.Entry elementReq : section.entrySet()) {
                        if (!requirementRegexPattern.matcher((CharSequence)elementReq.getKey()).matches() || !((String)elementReq.getKey()).equalsIgnoreCase(elementId)) continue;
                        Regex regex = InittypesFactory.eINSTANCE.createRegex();
                        regex.setExpression((String)elementReq.getValue());
                        requirement.setRegexReq(regex);
                        break;
                    }
                    for (Map.Entry elementAttributeName : section.entrySet()) {
                        String elementIdAttribute = ((String)elementAttributeName.getKey()).replaceAll("Attribute\\d+Name", "");
                        String elementIdAttributeRegex = ((String)elementAttributeName.getKey()).replace("Name", "");
                        if (!attributeNamePattern.matcher((CharSequence)elementAttributeName.getKey()).matches() || !elementIdAttribute.equalsIgnoreCase(elementId)) continue;
                        Attribute attribute = InittypesFactory.eINSTANCE.createAttribute();
                        attribute.setNameAttribute((String)elementAttributeName.getValue());
                        for (Map.Entry elementAttributeRegex : section.entrySet()) {
                            String elementIdAttributeRegexFound = ((String)elementAttributeRegex.getKey()).replace("Name", "");
                            if (!attributeRegexPattern.matcher((CharSequence)elementAttributeRegex.getKey()).matches() || !elementIdAttributeRegex.equalsIgnoreCase(elementIdAttributeRegexFound)) continue;
                            Regex regex = InittypesFactory.eINSTANCE.createRegex();
                            regex.setExpression((String)elementAttributeRegex.getValue());
                            attribute.setRegexAttribute(regex);
                            break;
                        }
                        requirement.getAttributesReq().add((Object)attribute);
                    }
                    TypeInDoc.getRequirements().add((Object)requirement);
                }
                fileType.getTypes().add((Object)TypeInDoc);
            }
            ++n2;
        }
        return fileType;
    }

    private static String getMethodName(IFile resource) {
        return resource.getFullPath().toString();
    }

    public static List<String> parseCommaSeparated(String strToParse) {
        String[] strs;
        LinkedList<String> strList = new LinkedList<String>();
        String[] stringArray = strs = strToParse.split(",");
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (!"".equals(str)) {
                strList.add(str);
            }
            ++n2;
        }
        return strList;
    }

    public static String serializeCommaSeparated(List<String> strList) {
        StringBuilder b = new StringBuilder();
        for (String str : strList) {
            b.append(str);
            b.append(',');
        }
        if (!strList.isEmpty()) {
            b.deleteCharAt(b.length() - 1);
        }
        return b.toString();
    }

    public static <T> T create(EClass eclass) {
        return (T)eclass.getEPackage().getEFactoryInstance().create(eclass);
    }

    private boolean fileDeleted(IFile resource) {
        boolean result = false;
        final String resourceName = IniManagerRegistry.getMethodName(resource);
        FileType ft = (FileType)Iterables.find(this.typeModel.getFileTypes(), (Predicate)new Predicate<FileType>(){

            public boolean apply(FileType arg0) {
                return Objects.equal((Object)resourceName, (Object)arg0.getName());
            }
        }, null);
        if (ft != null) {
            EcoreUtil.delete((EObject)ft);
        }
        return result;
    }

    private void fileUpdated(IFile resource) {
        this.fileDeleted(resource);
        this.fileAdded(resource);
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getResource() != null) {
            switch (delta.getKind()) {
                case 1: {
                    this.visit(delta.getResource());
                    break;
                }
                case 2: {
                    this.visit(delta.getResource(), kind.DELETE);
                    break;
                }
                case 4: {
                    this.visit(delta.getResource(), kind.MODIFY);
                }
            }
        }
        return true;
    }

    public TypeModel getTypeModel() {
        return this.typeModel;
    }

    public static void save(IFile typesFile, FileType fileType) {
        IniManagerRegistry.save(typesFile, Collections.singleton(fileType));
    }

    public static void save(IFile typesFile, Collection<FileType> fileTypes) {
        Wini ini = new Wini();
        StringBuilder typeNames = new StringBuilder();
        Profile.Section section = ini.add("Types");
        section.add("Names", (Object)typeNames);
        URI uri = typesFile.getLocationURI();
        try {
            ini.store(new File(uri));
            if (!typesFile.exists()) {
                typesFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    static enum kind {
        ADD,
        MODIFY,
        DELETE;

    }
}

