/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.model.scopes;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.polarsys.reqcycle.traceability.model.scopes.IScope;
import org.polarsys.reqcycle.uri.model.Reachable;

public class CompositeScope
implements IScope {
    ArrayDeque<IScope> scopes = new ArrayDeque();
    Set<Reachable> cache = new HashSet<Reachable>();
    boolean flag = false;

    public CompositeScope() {
    }

    public CompositeScope(Iterable<IScope> initialScopes) {
        this.scopes.addAll(Lists.newArrayList(initialScopes));
    }

    public void remove(IScope source) {
        this.scopes.remove(source);
        this.flag = false;
    }

    public void add(IScope scope) {
        this.scopes.add(scope);
        this.flag = false;
    }

    @Override
    public Iterator<Reachable> getReachables() {
        if (!this.flag) {
            this.flag = true;
            for (IScope s : this.scopes) {
                this.cache.addAll(Sets.newHashSet(s.getReachables()));
            }
        }
        return Iterators.unmodifiableIterator(this.cache.iterator());
    }
}

