/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.iterators.yieldadapters;

import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.concurrent.SynchronousQueue;
import org.polarsys.reqcycle.utils.iterators.collectors.Collector;
import org.polarsys.reqcycle.utils.iterators.exceptions.CollectionAbortedException;
import org.polarsys.reqcycle.utils.iterators.exceptions.RedundancyException;
import org.polarsys.reqcycle.utils.iterators.handlers.ResultHandler;
import org.polarsys.reqcycle.utils.iterators.utils.YieldAdapterIterable;
import org.polarsys.reqcycle.utils.iterators.utils.YieldAdapterIterator;
import org.polarsys.reqcycle.utils.iterators.yieldadapters.YieldAdapter;

public class RedundancyAwareThreadedYieldAdapter<T>
implements YieldAdapter<T> {
    @Override
    public YieldAdapterIterable<T> adapt(final Collector<T> client) {
        return new YieldAdapterIterable<T>(){

            @Override
            public YieldAdapterIterator<T> iterator() {
                final SynchronousQueue synchronousQueue = new SynchronousQueue();
                final SynchronousQueue returnQueue = new SynchronousQueue();
                final Thread collectThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            returnQueue.take();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException("Error with yield adapter", e);
                        }
                        try {
                            try {
                                final LinkedHashSet results = new LinkedHashSet();
                                client.collect(new ResultHandler<T>(){

                                    @Override
                                    public void handleResult(T value) throws CollectionAbortedException, RedundancyException {
                                        if (results.contains(value)) {
                                            throw new RedundancyException(value);
                                        }
                                        try {
                                            synchronousQueue.put(new ValueMessage(value));
                                            results.add(value);
                                            returnQueue.take();
                                        }
                                        catch (InterruptedException e) {
                                            throw new CollectionAbortedException(e);
                                        }
                                    }
                                });
                                synchronousQueue.put(new EndMessage());
                            }
                            catch (CollectionAbortedException collectionAborted) {
                                if (!(collectionAborted.getCause() instanceof InterruptedException)) {
                                    synchronousQueue.put(new AbortedMessage());
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                };
                collectThread.start();
                return new YieldAdapterIterator<T>(){
                    private Message messageWaiting = null;

                    @Override
                    public boolean hasNext() {
                        this.readNextMessage();
                        return !StopMessage.class.isAssignableFrom(this.messageWaiting.getClass());
                    }

                    @Override
                    public T next() {
                        this.readNextMessage();
                        if (StopMessage.class.isAssignableFrom(this.messageWaiting.getClass())) {
                            throw new NoSuchElementException();
                        }
                        Object value = ((ValueMessage)this.messageWaiting).value;
                        this.messageWaiting = null;
                        return value;
                    }

                    private void readNextMessage() {
                        if (this.messageWaiting == null) {
                            try {
                                returnQueue.put(new Object());
                                this.messageWaiting = (Message)synchronousQueue.take();
                            }
                            catch (InterruptedException interruptedException) {
                                this.messageWaiting = new EndMessage();
                            }
                        }
                    }

                    @Override
                    public void remove() {
                    }

                    protected void finalize() throws Throwable {
                        this.dispose();
                        super.finalize();
                    }

                    @Override
                    public void dispose() {
                        collectThread.interrupt();
                    }
                };
            }
        };
    }

    private class AbortedMessage
    extends StopMessage {
        private AbortedMessage() {
        }
    }

    private class EndMessage
    extends StopMessage {
        private EndMessage() {
        }
    }

    class Message {
        Message() {
        }
    }

    private abstract class StopMessage
    extends Message {
        private StopMessage() {
        }
    }

    class ValueMessage
    extends Message {
        final T value;

        ValueMessage(T value) {
            this.value = value;
        }
    }
}

