/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IStartup;
import org.polarsys.reqcycle.impact.Impact.ImpactAnalysis;
import org.polarsys.reqcycle.repository.connector.update.MutexRule;
import org.polarsys.reqcycle.repository.connector.update.UpdateRequirementSourcesHandler;
import org.polarsys.reqcycle.repository.connector.update.preferences.PreferenceController;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class JobUpdateReference
extends Job
implements IStartup {
    IConfigurationManager configurationManager = (IConfigurationManager)ZigguratInject.make(IConfigurationManager.class);
    IDataManager dataManager = (IDataManager)ZigguratInject.make(IDataManager.class);
    List<RequirementSource> listReqSourcesInRef;

    public JobUpdateReference() {
        super("Job update reference");
        this.setRule(MutexRule.INSTANCE);
    }

    public void earlyStartup() {
        this.schedule();
    }

    protected IStatus run(IProgressMonitor monitor) {
        int timer = PreferenceController.getRefreshTime() * 1000;
        try {
            try {
                Boolean isImpactAnalysis = PreferenceController.isImpactAnalysis();
                if (this.dataManager != null) {
                    Set listReqSources = this.dataManager.getRequirementSources();
                    UpdateRequirementSourcesHandler updateReqSourceHandler = new UpdateRequirementSourcesHandler();
                    if (listReqSources != null) {
                        this.listReqSourcesInRef = new ArrayList<RequirementSource>();
                        for (RequirementSource reqS : listReqSources) {
                            if (reqS.getDestinationURI() != null) continue;
                            this.listReqSourcesInRef.add(reqS);
                        }
                    }
                    HashMap<RequirementSource, RequirementSource> storageOldNewReqSources = new HashMap();
                    storageOldNewReqSources = updateReqSourceHandler.createCopyReqSrc(this.listReqSourcesInRef, this.dataManager);
                    Map<Object, Object> mapReqSourcesWithImpactAna = new HashMap();
                    mapReqSourcesWithImpactAna = updateReqSourceHandler.generateAllImpacts(storageOldNewReqSources, monitor);
                    String destinationPath = PreferenceController.getPathForImpactAnalysis();
                    for (Map.Entry<Object, Object> reqSrcWithImpact : mapReqSourcesWithImpactAna.entrySet()) {
                        updateReqSourceHandler.finalizedUpdateReqSrc((RequirementSource)reqSrcWithImpact.getKey(), (ImpactAnalysis)reqSrcWithImpact.getValue(), this.dataManager, storageOldNewReqSources);
                        if (!isImpactAnalysis.booleanValue() || destinationPath == null || destinationPath.isEmpty()) continue;
                        updateReqSourceHandler.saveImpactAnalysis(destinationPath, (ImpactAnalysis)reqSrcWithImpact.getValue(), ((RequirementSource)reqSrcWithImpact.getKey()).getName());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.schedule(timer);
            }
        }
        finally {
            this.schedule(timer);
        }
        return Status.OK_STATUS;
    }
}

