/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.ui.numberspropseditor.internal.components;

import org.eclipse.swt.widgets.Composite;
import org.polarsys.reqcycle.ui.eattrpropseditor.api.AbstractPropsTextEditorComponent;

public class IntegerPropsEditorComponent
extends AbstractPropsTextEditorComponent<Integer> {
    private String errorMessage;

    public IntegerPropsEditorComponent(String attributeName, Composite parent, int style) {
        super(attributeName, Integer.class, parent, style);
    }

    protected Integer convertFromString(String textValue) {
        try {
            return Integer.parseInt(textValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected boolean isTextValid(String textValue) {
        try {
            Integer.parseInt(textValue);
            return true;
        }
        catch (NumberFormatException e) {
            this.errorMessage = "Not an int. " + e.getMessage();
            return false;
        }
    }

    protected String getErrorMessage() {
        return this.errorMessage;
    }
}

