/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.export.rmf.transform;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.polarsys.reqcycle.export.rmf.page.WizardController;
import org.polarsys.reqcycle.export.rmf.transform.IRequirementProvider;
import org.polarsys.reqcycle.export.rmf.transform.RequirementSourceReqProvider;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementSourceDataPackage;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class ReqIFExport {
    private WizardController controller;
    static IDataModelManager modelManager = (IDataModelManager)ZigguratInject.make(IDataModelManager.class);
    private ReqIF reqif;
    private Map<EDataType, DatatypeDefinition> basicTypesMapping;
    private Map<EDataType, EClass> attDefinitions;
    private Map<EDataType, EClass> attValues;
    private Map<EClass, SpecObjectType> specObjectTypes;
    private Map<EClass, Map<EStructuralFeature, AttributeDefinition>> attributeDefinitions;
    private SpecObjectType reqType;

    public ReqIFExport(WizardController controller) {
        this.controller = controller;
    }

    public ReqIF transform() {
        URI uri = this.controller.getOutputUri();
        Iterator<IRequirementProvider> reqResult = this.controller.getReqResult().iterator();
        this.basicTypesMapping = Maps.newHashMap();
        this.attDefinitions = Maps.newHashMap();
        this.attValues = Maps.newHashMap();
        this.specObjectTypes = Maps.newHashMap();
        this.attributeDefinitions = Maps.newHashMap();
        this.reqif = ReqIF10Factory.eINSTANCE.createReqIF();
        DatatypeDefinitionString t = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionString();
        t.setLongName("String");
        this.reqif.setCoreContent(ReqIF10Factory.eINSTANCE.createReqIFContent());
        this.reqif.getCoreContent().getDatatypes().add((Object)t);
        this.basicTypesMapping.put(EcorePackage.Literals.ESTRING, (DatatypeDefinition)t);
        this.attDefinitions.put(EcorePackage.Literals.ESTRING, ReqIF10Package.Literals.ATTRIBUTE_DEFINITION_STRING);
        this.attValues.put(EcorePackage.Literals.ESTRING, ReqIF10Package.Literals.ATTRIBUTE_VALUE_STRING);
        t = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionInteger();
        t.setLongName("Integer");
        this.reqif.getCoreContent().getDatatypes().add((Object)t);
        this.basicTypesMapping.put(EcorePackage.Literals.EINT, (DatatypeDefinition)t);
        this.attDefinitions.put(EcorePackage.Literals.EINT, ReqIF10Package.Literals.ATTRIBUTE_DEFINITION_INTEGER);
        this.attValues.put(EcorePackage.Literals.EINT, ReqIF10Package.Literals.ATTRIBUTE_VALUE_INTEGER);
        t = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionBoolean();
        t.setLongName("Boolean");
        this.reqif.getCoreContent().getDatatypes().add((Object)t);
        this.basicTypesMapping.put(EcorePackage.Literals.EBOOLEAN, (DatatypeDefinition)t);
        this.attDefinitions.put(EcorePackage.Literals.EBOOLEAN, ReqIF10Package.Literals.ATTRIBUTE_DEFINITION_BOOLEAN);
        this.attValues.put(EcorePackage.Literals.EBOOLEAN, ReqIF10Package.Literals.ATTRIBUTE_VALUE_BOOLEAN);
        t = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionInteger();
        t.setLongName("Long");
        this.reqif.getCoreContent().getDatatypes().add((Object)t);
        this.basicTypesMapping.put(EcorePackage.Literals.ELONG, (DatatypeDefinition)t);
        this.attDefinitions.put(EcorePackage.Literals.ELONG, ReqIF10Package.Literals.ATTRIBUTE_DEFINITION_INTEGER);
        this.attValues.put(EcorePackage.Literals.ELONG, ReqIF10Package.Literals.ATTRIBUTE_VALUE_INTEGER);
        t = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionReal();
        t.setLongName("Float");
        this.reqif.getCoreContent().getDatatypes().add((Object)t);
        this.basicTypesMapping.put(EcorePackage.Literals.EFLOAT, (DatatypeDefinition)t);
        this.attDefinitions.put(EcorePackage.Literals.EFLOAT, ReqIF10Package.Literals.ATTRIBUTE_DEFINITION_REAL);
        this.attValues.put(EcorePackage.Literals.EFLOAT, ReqIF10Package.Literals.ATTRIBUTE_VALUE_REAL);
        t = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionReal();
        t.setLongName("Double");
        this.reqif.getCoreContent().getDatatypes().add((Object)t);
        this.basicTypesMapping.put(EcorePackage.Literals.EDOUBLE, (DatatypeDefinition)t);
        this.attDefinitions.put(EcorePackage.Literals.EDOUBLE, ReqIF10Package.Literals.ATTRIBUTE_DEFINITION_REAL);
        this.attValues.put(EcorePackage.Literals.EDOUBLE, ReqIF10Package.Literals.ATTRIBUTE_VALUE_REAL);
        this.reqType = ReqIF10Factory.eINSTANCE.createSpecObjectType();
        this.reqType.setLongName("Requirement");
        this.handleAttribute((EStructuralFeature)RequirementSourceDataPackage.Literals.ABSTRACT_ELEMENT__ID, RequirementSourceDataPackage.Literals.REQUIREMENT, this.reqType);
        this.handleAttribute((EStructuralFeature)RequirementSourceDataPackage.Literals.ABSTRACT_ELEMENT__TEXT, RequirementSourceDataPackage.Literals.REQUIREMENT, this.reqType);
        this.reqif.getCoreContent().getSpecTypes().add((Object)this.reqType);
        this.handleTypes(reqResult);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(uri);
        r.getContents().add((Object)this.reqif);
        try {
            r.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.reqif;
    }

    private void handleAttribute(EStructuralFeature newAttribute, EClass classDescriptor, SpecObjectType specType) {
        if (newAttribute.getEType() instanceof EDataType) {
            AttributeDefinition attDef = (AttributeDefinition)ReqIF10Factory.eINSTANCE.create(this.attDefinitions.get(newAttribute.getEType()));
            HashMap map = this.attributeDefinitions.get(classDescriptor);
            if (map == null) {
                map = Maps.newHashMap();
                this.attributeDefinitions.put(classDescriptor, map);
            }
            map.put(newAttribute, attDef);
            attDef.setLongName(newAttribute.getName());
            EStructuralFeature typeFeature = attDef.eClass().getEStructuralFeature("type");
            attDef.eSet(typeFeature, (Object)this.basicTypesMapping.get(newAttribute.getEType()));
            specType.getSpecAttributes().add((Object)attDef);
        }
    }

    private void handleTypes(Iterator<IRequirementProvider> reqResult) {
        while (reqResult.hasNext()) {
            IRequirementProvider iReqProvider = reqResult.next();
            if (!(iReqProvider instanceof RequirementSourceReqProvider)) continue;
            RequirementSource source = ((RequirementSourceReqProvider)iReqProvider).getSource();
            Specification specification = ReqIF10Factory.eINSTANCE.createSpecification();
            EList listSpecHierarchy = specification.getChildren();
            SpecificationType specificationType = ReqIF10Factory.eINSTANCE.createSpecificationType();
            specification.setType(specificationType);
            specification.setLongName(source.getName());
            this.reqif.getCoreContent().getSpecTypes().add((Object)specificationType);
            this.reqif.getCoreContent().getSpecifications().add((Object)specification);
            IDataModel dataModel = modelManager.getDataModelByURI(source.getDataModelURI());
            Collection types = dataModel.getTypes();
            for (IType iType : types) {
                if (!(iType instanceof IRequirementType)) continue;
                EClass classDescriptor = (EClass)((IAdaptable)iType).getAdapter(EClass.class);
                SpecObjectType specType = ReqIF10Factory.eINSTANCE.createSpecObjectType();
                this.specObjectTypes.put(classDescriptor, specType);
                specType.setLongName(iType.getName());
                for (IAttribute att : ((IRequirementType)iType).getAttributes()) {
                    EStructuralFeature feature = (EStructuralFeature)((IAdaptable)att).getAdapter(EStructuralFeature.class);
                    this.handleAttribute(feature, classDescriptor, specType);
                }
                this.reqif.getCoreContent().getSpecTypes().add((Object)specType);
            }
            this.handleSpecHierarchy(iReqProvider.getRequirements(), null, (EList<SpecHierarchy>)listSpecHierarchy);
        }
    }

    private void handleSpecHierarchy(EList<AbstractElement> requirements, EList<SpecHierarchy> specHierarchies, EList<SpecHierarchy> listSpecHierarchy) {
        for (AbstractElement abstractElement : requirements) {
            SpecHierarchy specHierarchy = ReqIF10Factory.eINSTANCE.createSpecHierarchy();
            SpecObject so = ReqIF10Factory.eINSTANCE.createSpecObject();
            so.setDesc(abstractElement.getText());
            EClass classDescriptor = abstractElement.eClass();
            for (EStructuralFeature feature : classDescriptor.getEAllStructuralFeatures()) {
                Map<EStructuralFeature, AttributeDefinition> map;
                if ("scopes".equals(feature.getName()) || feature != RequirementSourceDataPackage.Literals.ABSTRACT_ELEMENT__ID && feature != RequirementSourceDataPackage.Literals.ABSTRACT_ELEMENT__TEXT && RequirementSourceDataPackage.eINSTANCE.equals(feature.getEContainingClass().getEPackage()) || (map = this.attributeDefinitions.get(classDescriptor)) == null) continue;
                AttributeDefinition def = map.get(feature);
                EClass attValClass = this.attValues.get(feature.getEType());
                AttributeValue attVal = (AttributeValue)ReqIF10Factory.eINSTANCE.create(attValClass);
                EStructuralFeature theValueFeature = attVal.eClass().getEStructuralFeature("theValue");
                attVal.eSet(theValueFeature, this.convert(abstractElement.eGet(feature)));
                EStructuralFeature defFeature = attVal.eClass().getEStructuralFeature("definition");
                attVal.eSet(defFeature, (Object)def);
                so.getValues().add((Object)attVal);
            }
            if (RequirementSourceDataPackage.Literals.SECTION.equals(abstractElement.eClass())) {
                specHierarchy.setLongName(abstractElement.getId());
            } else if (RequirementSourceDataPackage.Literals.REQUIREMENT.equals(abstractElement.eClass())) {
                so.setType(this.reqType);
                specHierarchy.setObject(so);
            } else {
                so.setType(this.specObjectTypes.get(classDescriptor));
                specHierarchy.setObject(so);
            }
            this.reqif.getCoreContent().getSpecObjects().add((Object)so);
            if (specHierarchies == null) {
                listSpecHierarchy.add((Object)specHierarchy);
            } else {
                specHierarchies.add((Object)specHierarchy);
            }
            if (!(abstractElement instanceof Section) || ((Section)abstractElement).getChildren().isEmpty()) continue;
            this.handleSpecHierarchy((EList<AbstractElement>)((Section)abstractElement).getChildren(), (EList<SpecHierarchy>)specHierarchy.getChildren(), listSpecHierarchy);
        }
    }

    private Object convert(Object obj) {
        if (obj instanceof Integer) {
            return BigInteger.valueOf(((Integer)obj).intValue());
        }
        if (obj instanceof Long) {
            return BigInteger.valueOf((Long)obj);
        }
        if (obj instanceof Float) {
            return new Double(((Float)obj).floatValue());
        }
        return obj;
    }
}

