/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import java.util.ArrayList;
import java.util.Collection;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.editors.PopupCellEditor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ProrEnumerationMultiValueCellEditor
extends PopupCellEditor {
    private ArrayList<EnumValue> itemList = new ArrayList();
    private final DatatypeDefinitionEnumeration dde;
    private AttributeValueEnumeration attributeValue;
    private final EditingDomain editingDomain;
    private Object parent;
    private Object affectedObject;

    public ProrEnumerationMultiValueCellEditor(AgileGrid agileGrid, DatatypeDefinitionEnumeration dde, Object parent, Object affectedObject, EditingDomain editingDomain, AdapterFactory adapterFactory) {
        super(agileGrid);
        this.dde = dde;
        this.editingDomain = editingDomain;
        this.parent = parent;
        this.affectedObject = affectedObject;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 1);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        Table table = new Table(composite, 32);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32 && e.item instanceof TableItem) {
                    TableItem item = (TableItem)e.item;
                    if (item.getChecked()) {
                        ProrEnumerationMultiValueCellEditor.this.itemList.add((EnumValue)item.getData());
                    } else {
                        ProrEnumerationMultiValueCellEditor.this.itemList.remove((EnumValue)item.getData());
                    }
                }
            }
        });
        for (EnumValue enumValue : this.dde.getSpecifiedValues()) {
            TableItem tableItem = new TableItem(table, 0);
            String enumId = enumValue.getLongName() == null ? enumValue.getIdentifier() : enumValue.getLongName();
            tableItem.setText(enumId);
            tableItem.setData((Object)enumValue);
            if (!this.attributeValue.getValues().contains((Object)enumValue)) continue;
            tableItem.setChecked(true);
            this.itemList.add(enumValue);
        }
        Composite buttonPanel = new Composite(composite, 0);
        buttonPanel.setLayoutData((Object)new GridData(4, 4, true, false));
        buttonPanel.setLayout((Layout)new FillLayout(256));
        Button cancel = new Button(buttonPanel, 8);
        cancel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProrEnumerationMultiValueCellEditor.this.fireCancelEditor();
            }
        });
        Button ok = new Button(buttonPanel, 8);
        ok.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_SAVE_EDIT"));
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProrEnumerationMultiValueCellEditor.this.fireApplyEditorValue();
            }
        });
        return composite;
    }

    protected Object doGetValue() {
        if (this.itemList == null) {
            return super.doGetValue();
        }
        CompoundCommand cmd = new CompoundCommand("Set Enumeration"){

            public Collection<?> getAffectedObjects() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(ProrEnumerationMultiValueCellEditor.this.affectedObject);
                return list;
            }
        };
        if (this.attributeValue.eContainer() == null) {
            cmd.append(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.parent, (Object)ReqIF10Package.Literals.SPEC_ELEMENT_WITH_ATTRIBUTES__VALUES, (Object)this.attributeValue));
        }
        cmd.append(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.attributeValue, (Object)ReqIF10Package.Literals.ATTRIBUTE_VALUE_ENUMERATION__VALUES, this.itemList));
        this.editingDomain.getCommandStack().execute((Command)cmd);
        return this.attributeValue;
    }

    protected void doSetValue(Object value) {
        if (value instanceof AttributeValueEnumeration) {
            this.attributeValue = (AttributeValueEnumeration)value;
        }
        super.doSetValue(value);
    }

    protected void fireCancelEditor() {
        this.itemList = null;
        super.fireCancelEditor();
    }

    protected void openPopupBox(Control parent) {
        super.openPopupBox(parent);
        Display display = Display.getCurrent();
        Shell shell = display.getActiveShell();
        shell.pack();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

