/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.preferences;

import java.util.Map;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.reqif10.pror.edit.presentation.service.PresentationInterface;
import org.eclipse.rmf.reqif10.pror.editor.preferences.PreferenceConstants;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10EditorPlugin;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.PresentationServiceManager;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ProrDefaultPresentationPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected void createFieldEditors() {
        this.setField(PreferenceConstants.P_DEFAULT_PRESENTATION_STRING, "String");
        this.setField(PreferenceConstants.P_DEFAULT_PRESENTATION_XHTML, "XHTML");
        this.setField(PreferenceConstants.P_DEFAULT_PRESENTATION_REAL, "Real");
        this.setField(PreferenceConstants.P_DEFAULT_PRESENTATION_INTEGER, "Integer");
        this.setField(PreferenceConstants.P_DEFAULT_PRESENTATION_ENUMERATION, "Enumeration");
        this.setField(PreferenceConstants.P_DEFAULT_PRESENTATION_BOOLEAN, "Boolean");
        this.setField(PreferenceConstants.P_DEFAULT_PRESENTATION_DATE, "Date");
    }

    private void setField(String fieldName, String label) {
        this.addField((FieldEditor)new ComboFieldEditor(fieldName, label, this.getEntryNamesAndValues(), this.getFieldEditorParent()));
    }

    private String[][] getEntryNamesAndValues() {
        Map<Class<? extends ProrPresentationConfiguration>, PresentationInterface> presentationMap = PresentationServiceManager.getPresentationInterfaceMap();
        String[][] result = new String[presentationMap.size() + 2][2];
        result[0][0] = "None";
        result[0][1] = "";
        result[1][0] = "Use Build-in";
        result[1][1] = "default_presentation_build_in";
        int i = 2;
        for (Class<? extends ProrPresentationConfiguration> key : presentationMap.keySet()) {
            result[i][0] = ProrUtil.substractPrefixPostfix(key, (String)"", (String)"ConfigurationImpl");
            result[i][1] = key.getCanonicalName();
            ++i;
        }
        return result;
    }

    public boolean performOk() {
        PresentationServiceManager.clearDefaultRenderers();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Reqif10EditorPlugin.getPlugin().getPreferenceStore());
        this.setDescription("IMPORTANT: currently, no test with respect to type mismatch is performed.");
    }
}

