/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.presentation;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.ReqIFHeader;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10Editor;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10EditorPlugin;
import org.eclipse.rmf.reqif10.pror.editor.presentation.ReqifSpecificationEditorInput;
import org.eclipse.rmf.reqif10.pror.provider.ReqIFContentItemProvider;
import org.eclipse.rmf.reqif10.pror.provider.VirtualSpecificationsItemProvider;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.ide.IDE;

public class ReqifMainForm {
    private final FormToolkit toolkit;
    private final ScrolledForm form;
    private final ReqIF reqif;
    private final Reqif10Editor reqifEditor;

    private ComposedAdapterFactory getAdapterFactory() {
        return (ComposedAdapterFactory)this.reqifEditor.getAdapterFactory();
    }

    public ReqifMainForm(Composite parent, Reqif10Editor rifEditor) {
        this.reqifEditor = rifEditor;
        this.reqif = rifEditor.getReqif();
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText(String.valueOf(this.getString("_UI_ReqifForm_ReqIfFile")) + ": " + URI.decode((String)this.reqif.eResource().getURI().lastSegment()));
        TableWrapLayout layout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)layout);
        Section helpSection = this.createSection(0);
        helpSection.setText(this.getString("_UI_Help_Get_Started_Title"));
        Text helpSectionClient = this.toolkit.createText((Composite)helpSection, this.getString("_UI_Help_Get_Started"), 74);
        helpSection.setClient((Control)helpSectionClient);
        this.createDocSection();
        this.createSpecSection();
        this.form.reflow(true);
    }

    private void createSpecSection() {
        final Section specSection = this.createSection(192);
        specSection.setText(this.getString("_UI_ReqifForm_Specifications"));
        specSection.setDescription(this.getString("_UI_ReqifForm_DblClickSpecifications"));
        Composite client = this.toolkit.createComposite((Composite)specSection);
        final ListViewer list = new ListViewer(client, 2052){

            public void update(Object element, String[] properties) {
                super.update(element, properties);
                specSection.layout();
            }

            public void update(Object[] elements, String[] properties) {
                super.update(elements, properties);
                specSection.layout();
            }
        };
        list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    ReqifMainForm.this.reqifEditor.setSelection(event.getSelection());
                }
            }
        });
        TableWrapLayout layout = new TableWrapLayout();
        client.setLayout((Layout)layout);
        specSection.setClient((Control)client);
        ReqIFContent coreContent = this.reqif.getCoreContent();
        if (coreContent == null) {
            coreContent = ReqIF10Factory.eINSTANCE.createReqIFContent();
            this.reqifEditor.getEditingDomain().getCommandStack().execute(SetCommand.create((EditingDomain)this.reqifEditor.getEditingDomain(), (Object)this.reqif, (Object)ReqIF10Package.Literals.REQ_IF__CORE_CONTENT, (Object)coreContent));
        }
        ReqIFContentItemProvider ip = (ReqIFContentItemProvider)ProrUtil.getItemProvider((AdapterFactory)this.getAdapterFactory(), (Object)coreContent);
        ip.getChildren((Object)coreContent);
        VirtualSpecificationsItemProvider root = (VirtualSpecificationsItemProvider)ip.getVirtualSpecifications((Object)coreContent);
        list.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.getAdapterFactory()));
        list.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.getAdapterFactory()));
        list.setInput((Object)root);
        root.addListener(new INotifyChangedListener(){

            public void notifyChanged(Notification notification) {
                if (list != null && !list.getControl().isDisposed()) {
                    list.refresh();
                    ReqifMainForm.this.form.reflow(true);
                }
            }
        });
        list.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element instanceof Specification) {
                    ReqifMainForm.this.openSpec((Specification)element);
                }
            }
        });
    }

    private void createDocSection() {
        ReqIFHeader header;
        if (this.reqif.getTheHeader() == null) {
            header = ReqIF10Factory.eINSTANCE.createReqIFHeader();
            Command cmd = SetCommand.create((EditingDomain)this.reqifEditor.getEditingDomain(), (Object)this.reqif, (Object)ReqIF10Package.Literals.REQ_IF__THE_HEADER, (Object)header);
            this.reqifEditor.getEditingDomain().getCommandStack().execute(cmd);
        } else {
            header = this.reqif.getTheHeader();
        }
        Section docSection = this.createSection(0);
        docSection.setText(this.getString("_UI_ReqifForm_DocumentProperties"));
        docSection.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.toolkit.createComposite((Composite)docSection);
        docSection.setClient((Control)client);
        TableWrapLayout layout = new TableWrapLayout();
        client.setLayout((Layout)layout);
        this.toolkit.createLabel(client, String.valueOf(this.getString("_UI_ReqifForm_Title")) + ": ");
        Text text = this.toolkit.createText(client, header.getTitle(), 2048);
        text.setLayoutData((Object)new TableWrapData(256));
        this.addModifyListener(text, header, ReqIF10Package.Literals.REQ_IF_HEADER__TITLE);
        this.toolkit.createLabel(client, String.valueOf(this.getString("_UI_ReqifForm_Comment")) + ": ");
        text = this.toolkit.createText(client, header.getComment(), 2114);
        text.setLayoutData((Object)new TableWrapData(256));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReqifMainForm.this.form.reflow(false);
            }
        });
        this.addModifyListener(text, header, ReqIF10Package.Literals.REQ_IF_HEADER__COMMENT);
        this.toolkit.createLabel(client, String.valueOf(this.getString("_UI_ReqifForm_CreateTime")) + ": ");
        String creationDate = "Unknown";
        if (header.getCreationTime() != null) {
            creationDate = header.getCreationTime().getTime().toString();
        }
        text = this.toolkit.createText(client, creationDate, 2048);
        text.setEnabled(false);
        text.setLayoutData((Object)new TableWrapData(256));
        this.toolkit.createLabel(client, String.valueOf(this.getString("_UI_ReqifForm_SourceToolId")) + ": ");
        text = this.toolkit.createText(client, header.getSourceToolId(), 2048);
        text.setEnabled(false);
        text.setLayoutData((Object)new TableWrapData(256));
        this.toolkit.createLabel(client, String.valueOf(this.getString("_UI_ReqifForm_ReqIfToolId")) + ": ");
        text = this.toolkit.createText(client, header.getReqIFToolId(), 2048);
        text.setEnabled(false);
        text.setLayoutData((Object)new TableWrapData(256));
        this.toolkit.createLabel(client, String.valueOf(this.getString("_UI_ReqifForm_ReqIfVersion")) + ": ");
        text = this.toolkit.createText(client, header.getReqIFVersion(), 2048);
        text.setEnabled(false);
        text.setLayoutData((Object)new TableWrapData(256));
        this.toolkit.createLabel(client, String.valueOf(this.getString("_UI_ReqifForm_Identifier")) + ": ");
        final Text idText = this.toolkit.createText(client, header.getIdentifier(), 2048);
        idText.setEnabled(false);
        idText.setLayoutData((Object)new TableWrapData(256));
        header.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                idText.setText(header.getIdentifier());
            }
        });
        this.toolkit.createLabel(client, String.valueOf(this.getString("_UI_ReqifForm_RepositoryId")) + ": ");
        text = this.toolkit.createText(client, header.getRepositoryId(), 2048);
        text.setEnabled(false);
        text.setLayoutData((Object)new TableWrapData(256));
    }

    private void addModifyListener(final Text text, ReqIFHeader header, final EAttribute feature) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Command cmd = SetCommand.create((EditingDomain)ReqifMainForm.this.reqifEditor.getEditingDomain(), (Object)ReqifMainForm.this.reqif.getTheHeader(), (Object)feature, (Object)text.getText());
                ReqifMainForm.this.reqifEditor.getEditingDomain().getCommandStack().execute(cmd);
            }
        });
    }

    private Section createSection(int flags) {
        Section section = this.toolkit.createSection(this.form.getBody(), 0x112 | flags);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ReqifMainForm.this.form.reflow(true);
            }
        });
        return section;
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    private void openSpec(Specification spec) {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            ReqifSpecificationEditorInput editorInput = new ReqifSpecificationEditorInput(this.reqifEditor, spec);
            IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)"org.eclipse.rmf.reqif10.pror.SpecificationEditor");
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private String getString(String key) {
        return Reqif10EditorPlugin.INSTANCE.getString(key);
    }
}

