/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10Editor;
import org.eclipse.rmf.reqif10.search.criteria.Criteria;
import org.eclipse.rmf.reqif10.search.edit.util.ReqIFEditSearcher;
import org.eclipse.rmf.reqif10.search.ui.ReqIFSearchQuery;
import org.eclipse.rmf.reqif10.search.ui.ReqIFSearchUIPlugin;
import org.eclipse.rmf.reqif10.search.ui.masterdetails.CriteriasMasterDetailsBlock;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;

public class ReqIFSearchPage
extends DialogPage
implements ISearchPage,
IReplacePage {
    private static final String REQIF_EXTENSION = "reqif";
    private ISearchPageContainer container;
    private CriteriasMasterDetailsBlock masterDetailsBlock;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new FillLayout());
        ManagedForm managedForm = new ManagedForm(composite);
        this.masterDetailsBlock = new CriteriasMasterDetailsBlock();
        this.masterDetailsBlock.createContent((IManagedForm)managedForm);
        this.container.setPerformActionEnabled(true);
        this.setControl((Control)parent);
    }

    private List<IResource> getResources() {
        IResource[] resources = new IResource[]{};
        switch (this.container.getSelectedScope()) {
            case 1: {
                Object[] objects = ((IStructuredSelection)this.container.getSelection()).toArray();
                HashSet<IResource> resList = new HashSet<IResource>(objects.length);
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    URI eUri;
                    EObject eObject;
                    Resource eResource;
                    Object object = objectArray[n2];
                    if (object instanceof IResource) {
                        resList.add((IResource)object);
                    } else if (object instanceof EObject && (eResource = (eObject = (EObject)object).eResource()) != null && (eUri = eResource.getURI()).isPlatformResource()) {
                        String platformString = eUri.toPlatformString(true);
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
                        resList.add(resource);
                    }
                    ++n2;
                }
                resources = resList.toArray(new IResource[0]);
                break;
            }
            case 0: {
                resources = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                break;
            }
            case 2: {
                resources = ReqIFSearchPage.convertToResources(this.container.getSelectedWorkingSets());
            }
        }
        return this.getReqIFResources(resources);
    }

    private List<IResource> getReqIFResources(IResource[] resources) {
        ArrayList<IResource> reqIFResources = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile && resource.getFileExtension() != null && resource.getFileExtension().equals(REQIF_EXTENSION)) {
                reqIFResources.add(resource);
            } else if (resource instanceof IContainer) {
                try {
                    reqIFResources.addAll(this.getReqIFResources(((IContainer)resource).members()));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return reqIFResources;
    }

    private static IResource[] convertToResources(IWorkingSet[] workingSets) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet workingSet = workingSets[i];
            if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
            }
            IAdaptable[] elements = workingSet.getElements();
            int k = 0;
            while (k < elements.length) {
                IResource curr = (IResource)elements[k].getAdapter(IResource.class);
                if (curr != null) {
                    res.add(curr);
                }
                ++k;
            }
            ++i;
        }
        return res.toArray(new IResource[res.size()]);
    }

    final void updateOKStatus() {
        this.container.setPerformActionEnabled(true);
    }

    public Map<URI, EditingDomain> getEditorsURIMap() {
        final HashMap<URI, EditingDomain> uriMap = new HashMap<URI, EditingDomain>();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] editorReferences;
                IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    IEditorPart editorPart = editorReference.getEditor(false);
                    if (editorPart instanceof Reqif10Editor) {
                        try {
                            uriMap.put(EditUIUtil.getURI((IEditorInput)editorReference.getEditorInput()), ((IEditingDomainProvider)editorPart).getEditingDomain());
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
        });
        return uriMap;
    }

    public List<Resource> getEMFResources(Map<URI, EditingDomain> uriMap) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        List<IResource> resources = this.getResources();
        ArrayList<Resource> emfResources = new ArrayList<Resource>();
        for (IResource resource : resources) {
            URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toOSString(), (boolean)true);
            EditingDomain editingDomain = uriMap.get(uri);
            if (editingDomain != null) {
                emfResources.addAll((Collection<Resource>)editingDomain.getResourceSet().getResources());
                continue;
            }
            Resource emfResource = resourceSet.getResource(uri, true);
            if (emfResource == null) continue;
            emfResources.add(emfResource);
        }
        return emfResources;
    }

    public boolean performReplace() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Start Searching ...", -1);
                Map<URI, EditingDomain> uriMap = ReqIFSearchPage.this.getEditorsURIMap();
                List<Resource> resources = ReqIFSearchPage.this.getEMFResources(uriMap);
                ExtendedReqIFEdit reqIFEditSearcher = new ExtendedReqIFEdit(uriMap);
                reqIFEditSearcher.search(monitor, resources, ReqIFSearchPage.this.masterDetailsBlock.getCriterias(), true);
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ReqIFSearchUIPlugin.getPlugin().log(e);
        }
        catch (InterruptedException e) {
            ReqIFSearchUIPlugin.getPlugin().log(e);
        }
        return true;
    }

    public boolean performAction() {
        ISearchQuery query = this.newQuery();
        SearchView searchView = null;
        try {
            searchView = (SearchView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.search.ui.views.SearchView");
        }
        catch (PartInitException e) {
            ReqIFSearchUIPlugin.INSTANCE.log((Object)e);
        }
        NewSearchUI.runQueryInForeground((IRunnableContext)new ProgressMonitorDialog(this.getShell()), (ISearchQuery)query);
        if (searchView != null) {
            searchView.showSearchResult(query.getSearchResult());
        }
        return true;
    }

    private ISearchQuery newQuery() {
        return new ReqIFSearchQuery(this, this.masterDetailsBlock.getCriterias());
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    protected class ExtendedReqIFEdit
    extends ReqIFEditSearcher {
        private final Map<URI, EditingDomain> uriMap;

        public ExtendedReqIFEdit(Map<URI, EditingDomain> uriMap) {
            this.uriMap = uriMap;
        }

        protected Collection<EObject> search(IProgressMonitor monitor, Resource resource, Collection<Criteria> criterias, boolean replace) {
            HashMap<String, String> saveOptions = new HashMap<String, String>();
            saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
            Collection result = super.search(monitor, resource, criterias, replace);
            if (!this.uriMap.containsKey(resource.getURI())) {
                try {
                    resource.save(saveOptions);
                }
                catch (IOException e) {
                    ReqIFSearchUIPlugin.getPlugin().log(e);
                }
            }
            return result;
        }

        public void executeCommand(final EditingDomain editingDomain, final Command command) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExtendedReqIFEdit.super.executeCommand(editingDomain, command);
                }
            });
        }
    }
}

