/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.propertiesview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.ICellEditorProvider;
import org.agilemore.agilegrid.ICellRendererProvider;
import org.agilemore.agilegrid.IContentProvider;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.editor.propertiesview.ProrPropertyCellEditorProvider;
import org.eclipse.rmf.reqif10.pror.editor.propertiesview.ProrPropertyCellRendererProvider;
import org.eclipse.rmf.reqif10.pror.editor.propertiesview.ProrPropertyContentProvider;
import org.eclipse.rmf.reqif10.pror.editor.propertiesview.ProrPropertyLayoutAdvisor;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ProrPropertyControl
extends AgileGrid
implements PropertyChangeListener {
    protected ProrPropertyContentProvider contentProvider;
    private Object object;
    private AttributeValue removeValue;
    private AdapterFactory adapterFactory;

    public ProrPropertyControl(Composite parent, AdapterFactory adapterFactory, boolean showAllProps) {
        super(parent, 0x20020302);
        this.adapterFactory = adapterFactory;
        this.setBackground(Display.getDefault().getSystemColor(1));
        this.contentProvider = new ProrPropertyContentProvider(adapterFactory, showAllProps);
        super.setContentProvider((IContentProvider)this.contentProvider);
        this.setCellRendererProvider((ICellRendererProvider)new ProrPropertyCellRendererProvider(this, adapterFactory, this.contentProvider));
        this.setLayoutAdvisor((ILayoutAdvisor)new ProrPropertyLayoutAdvisor(this));
        this.setCellEditorProvider((ICellEditorProvider)new ProrPropertyCellEditorProvider(this, adapterFactory, this.contentProvider));
        this.setRowResizeCursor(new Cursor((Device)this.getDisplay(), 0));
        this.contentProvider.addPropertyChangeListener(this);
        this.configurePopupMenu(parent);
    }

    public void setContentProvider(ProrPropertyContentProvider prorPropertyContentProvider) {
        this.contentProvider = prorPropertyContentProvider;
        super.setContentProvider((IContentProvider)this.contentProvider);
        this.setCellRendererProvider((ICellRendererProvider)new ProrPropertyCellRendererProvider(this, this.adapterFactory, this.contentProvider));
        this.setLayoutAdvisor((ILayoutAdvisor)new ProrPropertyLayoutAdvisor(this));
        this.setCellEditorProvider((ICellEditorProvider)new ProrPropertyCellEditorProvider(this, this.adapterFactory, this.contentProvider));
        this.contentProvider.addPropertyChangeListener(this);
    }

    private void configurePopupMenu(Composite parent) {
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Cell[] cells = new Cell[]{ProrPropertyControl.this.getCell(e.x, e.y)};
                ProrPropertyControl.this.clearSelection();
                ProrPropertyControl.this.selectCells(cells);
            }
        });
        Menu menu = new Menu((Control)parent);
        final MenuItem item = new MenuItem(menu, 0);
        item.setText("Remove Value");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProrPropertyControl.this.removeValue();
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                AttributeValue av;
                ProrPropertyContentProvider.Descriptor descriptor;
                ProrPropertyContentProvider.PropertyRow row;
                item.setEnabled(false);
                ProrPropertyControl.this.removeValue = null;
                Cell[] selection = ProrPropertyControl.this.getCellSelection();
                if (selection.length == 1 && (row = ProrPropertyControl.this.contentProvider.getRowContent(selection[0].row)) instanceof ProrPropertyContentProvider.Descriptor && (descriptor = (ProrPropertyContentProvider.Descriptor)row).isRMFSpecific() && (av = descriptor.getAttributeValue()) != null && av.eContainer() != null) {
                    ProrPropertyControl.this.removeValue = av;
                    item.setEnabled(true);
                }
            }
        });
        this.setMenu(menu);
    }

    private void removeValue() {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.removeValue);
        if (editingDomain != null) {
            Command cmd = null;
            if (this.removeValue.eContainer() instanceof SpecElementWithAttributes) {
                cmd = RemoveCommand.create((EditingDomain)editingDomain, (Object)this.removeValue.eContainer(), (Object)ReqIF10Package.Literals.SPEC_ELEMENT_WITH_ATTRIBUTES__VALUES, (Object)this.removeValue);
            } else if (this.removeValue.eContainer() instanceof AttributeDefinition) {
                AttributeDefinition ad = (AttributeDefinition)this.removeValue.eContainer();
                cmd = SetCommand.create((EditingDomain)editingDomain, (Object)ad, (Object)ReqIF10Util.getDefaultValueFeature((AttributeDefinition)ad), null);
                System.out.println(cmd.canExecute());
            }
            if (cmd != null) {
                editingDomain.getCommandStack().execute(cmd);
                this.redrawCells(this.getCellSelection());
            } else {
                System.err.println("Don't know parent: " + this.removeValue.eContainer());
            }
        }
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection sel;
        if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() == 1) {
            Object obj = sel.getFirstElement();
            this.contentProvider.setContent(obj);
            this.object = obj;
            this.redraw();
            return;
        }
        this.contentProvider.setContent(null);
        this.redraw();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.isDisposed()) {
            return;
        }
        if (event.getPropertyName().equals("")) {
            this.contentProvider.setContent(this.object);
            this.redraw();
        }
    }
}

