/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.ui;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rmf.reqif10.pror.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.rmf.reqif10.pror.editor.propertiesview.ProrPropertySheetPage;
import org.eclipse.rmf.reqif10.pror.editor.util.ProrEditorUtil;
import org.eclipse.rmf.reqif10.pror.provider.ReqIF10ItemProviderAdapterFactory;
import org.eclipse.rmf.reqif10.pror.provider.ReqIFContentItemProvider;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.rmf.reqif10.search.ui.UsageSearchResult;
import org.eclipse.rmf.reqif10.xhtml.provider.XhtmlItemProviderAdapterFactory;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class ReqIFSearchResultPage
extends Page
implements ISearchResultPage,
IAdaptable {
    private UsageSearchResult searchResult;
    private String id;
    private TreeViewer treeViewer;
    private AdapterFactoryLabelProvider labelProvider;
    private AdapterFactoryContentProvider contentProvider;
    private Set<Object> matchedObjectsWithParents = new HashSet<Object>();
    private ComposedAdapterFactory adapterFactory;
    protected ProrPropertySheetPage propertySheetPage;
    private Set<Object> matchedObjects;

    private ComposedAdapterFactory createAdapterFactory() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReqIF10ItemProviderAdapterFactory(){

            public Adapter createReqIFContentAdapter() {
                return new ReqIFContentItemProvider((AdapterFactory)this);
            }
        });
        adapterFactory.addAdapterFactory((AdapterFactory)new XhtmlItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ConfigurationItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return adapterFactory;
    }

    public void createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent);
        this.adapterFactory = this.createAdapterFactory();
        this.labelProvider = new ResultLabelProvider((AdapterFactory)this.adapterFactory);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getElements(Object object) {
                if (object instanceof Collection) {
                    return ((Collection)object).toArray();
                }
                return super.getElements(object);
            }
        };
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ReqIFSearchResultPage.this.matchedObjectsWithParents.contains(element);
            }
        };
        this.treeViewer.addFilter(viewerFilter);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ReqIFSearchResultPage.this.showIfPossible(selection.getFirstElement());
                }
            }
        });
    }

    protected void showIfPossible(Object object) {
        if (object instanceof EObject) {
            ProrEditorUtil.getEditor((EObject)((EObject)object));
        }
    }

    public Object getUIState() {
        return this.treeViewer.getSelection();
    }

    public void setInput(ISearchResult searchResult, Object uiState) {
        if (searchResult instanceof UsageSearchResult) {
            this.searchResult = (UsageSearchResult)searchResult;
            this.matchedObjects = new HashSet<Object>();
            Map<Resource, Collection<EObject>> resultMap = this.searchResult.getSearchEntries();
            for (Map.Entry<Resource, Collection<EObject>> entry : resultMap.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                this.matchedObjects.addAll(entry.getValue());
            }
            this.matchedObjectsWithParents.clear();
            this.matchedObjectsWithParents.addAll(this.matchedObjects);
            HashSet<Resource> inputSet = new HashSet<Resource>();
            for (Object object : this.matchedObjects) {
                Object temp = this.contentProvider.getParent(object);
                while (temp != null) {
                    if (temp instanceof Resource) {
                        inputSet.add((Resource)temp);
                    }
                    this.matchedObjectsWithParents.add(temp);
                    temp = this.contentProvider.getParent(temp);
                }
            }
            this.treeViewer.setInput(inputSet);
            this.treeViewer.expandAll();
        } else {
            this.treeViewer.setInput(null);
        }
    }

    UsageSearchResult getSearchResult() {
        return this.searchResult;
    }

    public void setViewPart(ISearchResultViewPart part) {
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getLabel() {
        return this.searchResult == null ? "" : this.searchResult.getLabel();
    }

    public Control getControl() {
        return this.treeViewer.getControl();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return null;
    }

    private ProrPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ProrPropertySheetPage(null, (AdapterFactory)this.adapterFactory);
        }
        return this.propertySheetPage;
    }

    public void dispose() {
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        this.matchedObjectsWithParents.clear();
        super.dispose();
    }

    private final class ResultLabelProvider
    extends AdapterFactoryLabelProvider
    implements IColorProvider {
        private ResultLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getText(Object object) {
            if (object instanceof EObject) {
                ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)object).getText(object);
            }
            return super.getText(object);
        }

        public Color getForeground(Object object) {
            if (!ReqIFSearchResultPage.this.matchedObjects.contains(object)) {
                return Display.getCurrent().getSystemColor(15);
            }
            return super.getForeground(object);
        }
    }
}

