/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.tests.reqif10.serialization.uc001.tc1000;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.AttributeValueDate;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueReal;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.tests.reqif10.serialization.uc001.tc1000.TC1000SimpleContentModelBuilder;
import org.eclipse.rmf.tests.reqif10.serialization.util.AbstractTestCase;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TC1000SimpleContentTests
extends AbstractTestCase {
    static final String TEST_CASE_ID = "TC1000";
    static final String REFERENCE_DATA_FILENAME = TC1000SimpleContentTests.getWorkingFileName(TC1000SimpleContentTests.getReferenceDataFileName("TC1000", false));
    static final String EXPORT_DATA_FILENAME = TC1000SimpleContentTests.getWorkingFileName(TC1000SimpleContentTests.getFirstExportFileName("TC1000", false));
    static ReqIF originalReqIF = null;
    static ReqIF loadedReqIF = null;

    @BeforeClass
    public static void setupOnce() throws Exception {
        AbstractTestCase.setupOnce();
        originalReqIF = new TC1000SimpleContentModelBuilder().getReqIF();
        TC1000SimpleContentTests.saveReqIFFile((EObject)originalReqIF, REFERENCE_DATA_FILENAME);
        loadedReqIF = TC1000SimpleContentTests.loadReqIFFile(REFERENCE_DATA_FILENAME);
    }

    @Test
    public void testSchemaCompliance() throws Exception {
        this.validateAgainstSchema(REFERENCE_DATA_FILENAME);
    }

    @Test
    public void testReqIFNotNull() {
        Assert.assertNotNull((String)"The loaded ReqIF model shall not be Null", (Object)loadedReqIF);
    }

    @Test
    public void testNoProxies() throws IOException {
        EcoreUtil.resolveAll((EObject)loadedReqIF);
        Map map = EcoreUtil.ProxyCrossReferencer.find((EObject)loadedReqIF);
        Assert.assertEquals((long)0L, (long)map.size());
    }

    @Test
    public void testResave() throws IOException {
        try {
            TC1000SimpleContentTests.saveReqIFFile(EcoreUtil.copy((EObject)loadedReqIF), EXPORT_DATA_FILENAME);
        }
        catch (IOException ioe) {
            junit.framework.Assert.assertFalse((String)("We shall be able to save without exception. However the following exception occurred: " + ioe.toString()), (boolean)true);
        }
    }

    @Test
    public void testReqIF() {
        Assert.assertTrue((boolean)loadedReqIF.isSetCoreContent());
        Assert.assertFalse((boolean)loadedReqIF.isSetLang());
        Assert.assertTrue((boolean)loadedReqIF.isSetTheHeader());
        Assert.assertFalse((boolean)loadedReqIF.isSetToolExtensions());
    }

    @Test
    public void testReqIFHeader() {
        Assert.assertFalse((boolean)loadedReqIF.getTheHeader().isSetComment());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetCreationTime());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetIdentifier());
        Assert.assertFalse((boolean)loadedReqIF.getTheHeader().isSetRepositoryId());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetReqIFToolId());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetReqIFVersion());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetSourceToolId());
        Assert.assertTrue((boolean)loadedReqIF.getTheHeader().isSetTitle());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getCreationTime().getTime(), (Object)loadedReqIF.getTheHeader().getCreationTime().getTime());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getIdentifier(), (Object)loadedReqIF.getTheHeader().getIdentifier());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getReqIFToolId(), (Object)loadedReqIF.getTheHeader().getReqIFToolId());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getReqIFVersion(), (Object)loadedReqIF.getTheHeader().getReqIFVersion());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getSourceToolId(), (Object)loadedReqIF.getTheHeader().getSourceToolId());
        Assert.assertEquals((Object)originalReqIF.getTheHeader().getTitle(), (Object)loadedReqIF.getTheHeader().getTitle());
    }

    @Test
    public void testReqIFContent() {
        Assert.assertTrue((boolean)loadedReqIF.getCoreContent().isSetDatatypes());
        Assert.assertTrue((boolean)loadedReqIF.getCoreContent().isSetSpecifications());
        Assert.assertTrue((boolean)loadedReqIF.getCoreContent().isSetSpecObjects());
        Assert.assertFalse((boolean)loadedReqIF.getCoreContent().isSetSpecRelationGroups());
        Assert.assertFalse((boolean)loadedReqIF.getCoreContent().isSetSpecRelations());
        Assert.assertTrue((boolean)loadedReqIF.getCoreContent().isSetSpecTypes());
    }

    @Test
    public void testSpecObjectType() {
        ReqIFContent ReqIFContent2 = loadedReqIF.getCoreContent();
        Assert.assertTrue((boolean)ReqIFContent2.isSetSpecTypes());
        Assert.assertEquals((long)2L, (long)ReqIFContent2.getSpecTypes().size());
        SpecObjectType specObjectType = null;
        for (SpecType specType : ReqIFContent2.getSpecTypes()) {
            if (!(specType instanceof SpecObjectType)) continue;
            specObjectType = (SpecObjectType)specType;
            break;
        }
        Assert.assertNotNull((String)"SpecObjectType must be available", specObjectType);
        Assert.assertFalse((boolean)specObjectType.isSetDesc());
        Assert.assertTrue((boolean)specObjectType.isSetIdentifier());
        Assert.assertTrue((boolean)specObjectType.isSetLastChange());
        Assert.assertTrue((boolean)specObjectType.isSetLongName());
        Assert.assertTrue((boolean)specObjectType.isSetSpecAttributes());
    }

    @Test
    public void testSpecObject() {
        ReqIFContent reqIFContent = loadedReqIF.getCoreContent();
        Assert.assertTrue((boolean)reqIFContent.isSetSpecObjects());
        Assert.assertEquals((long)1L, (long)reqIFContent.getSpecObjects().size());
        SpecObject specObject = (SpecObject)reqIFContent.getSpecObjects().get(0);
        Assert.assertFalse((boolean)specObject.isSetDesc());
        Assert.assertTrue((boolean)specObject.isSetIdentifier());
        Assert.assertTrue((boolean)specObject.isSetLastChange());
        Assert.assertFalse((boolean)specObject.isSetLongName());
        Assert.assertTrue((boolean)specObject.isSetValues());
        Assert.assertTrue((boolean)specObject.isSetType());
        SpecObjectType expectedSpecObjectType = null;
        for (SpecType specType : reqIFContent.getSpecTypes()) {
            if (!(specType instanceof SpecObjectType)) continue;
            expectedSpecObjectType = (SpecObjectType)specType;
            break;
        }
        SpecObjectType specObjectType = specObject.getType();
        Assert.assertNotNull((Object)specObjectType);
        Assert.assertFalse((boolean)specObjectType.eIsProxy());
        Assert.assertEquals((Object)expectedSpecObjectType, (Object)specObjectType);
        Assert.assertEquals((long)8L, (long)specObject.getValues().size());
    }

    @Test
    public void testAttributeValueBooleanTc1000t() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(0);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueBoolean));
        AttributeValueBoolean attributeValueBooleanTc1000t = (AttributeValueBoolean)attributeValue;
        Assert.assertTrue((boolean)attributeValueBooleanTc1000t.isSetTheValue());
        Assert.assertTrue((boolean)attributeValueBooleanTc1000t.isTheValue());
    }

    @Test
    public void testAttributeValueBooleanTc1000f() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(1);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueBoolean));
        AttributeValueBoolean attributeValueBooleanTc1000f = (AttributeValueBoolean)attributeValue;
        Assert.assertTrue((boolean)attributeValueBooleanTc1000f.isSetTheValue());
        Assert.assertFalse((boolean)attributeValueBooleanTc1000f.isTheValue());
    }

    @Test
    public void testAttributeValueInteger() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(2);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueInteger));
        AttributeValueInteger attributeValueInteger = (AttributeValueInteger)attributeValue;
        Assert.assertTrue((boolean)attributeValueInteger.isSetTheValue());
        Assert.assertEquals((Object)new BigInteger("5000"), (Object)attributeValueInteger.getTheValue());
    }

    @Test
    public void testAttributeValueString() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(3);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueString));
        AttributeValueString attributeValueString = (AttributeValueString)attributeValue;
        Assert.assertTrue((boolean)attributeValueString.isSetTheValue());
        Assert.assertEquals((Object)"Plain", (Object)attributeValueString.getTheValue());
    }

    @Test
    public void testAttributeValueReal() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(4);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueReal));
        AttributeValueReal attributeValueReal = (AttributeValueReal)attributeValue;
        Assert.assertTrue((boolean)attributeValueReal.isSetTheValue());
        Assert.assertTrue((boolean)new Double(1234.5).equals(attributeValueReal.getTheValue()));
    }

    @Test
    public void testAttributeValueDate() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(5);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueDate));
        AttributeValueDate attributeValueDate = (AttributeValueDate)attributeValue;
        Assert.assertTrue((boolean)attributeValueDate.isSetTheValue());
        Assert.assertEquals((Object)EcoreUtil.createFromString((EDataType)ReqIF10Package.eINSTANCE.getDateTime(), (String)"2002-05-30T09:30:10+06:00"), (Object)attributeValueDate.getTheValue());
    }

    @Test
    public void testAttributeValueEnumeration() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(6);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueEnumeration));
        AttributeValueEnumeration attributeValueEnumeration = (AttributeValueEnumeration)attributeValue;
        Assert.assertTrue((boolean)attributeValueEnumeration.isSetValues());
        Assert.assertEquals((long)1L, (long)attributeValueEnumeration.getValues().size());
        Assert.assertEquals((Object)"TC1000 Yellow", (Object)((EnumValue)attributeValueEnumeration.getValues().get(0)).getLongName());
    }

    @Test
    public void testAttributeValueEnumerationMultiValue() {
        AttributeValue attributeValue = (AttributeValue)((SpecObject)loadedReqIF.getCoreContent().getSpecObjects().get(0)).getValues().get(7);
        Assert.assertTrue((boolean)(attributeValue instanceof AttributeValueEnumeration));
        AttributeValueEnumeration attributeValueEnumerationMultiValue = (AttributeValueEnumeration)attributeValue;
        Assert.assertTrue((boolean)attributeValueEnumerationMultiValue.isSetValues());
        Assert.assertEquals((long)3L, (long)attributeValueEnumerationMultiValue.getValues().size());
        Assert.assertEquals((Object)"TC1000 Yellow", (Object)((EnumValue)attributeValueEnumerationMultiValue.getValues().get(0)).getLongName());
        Assert.assertEquals((Object)"TC1000 Red", (Object)((EnumValue)attributeValueEnumerationMultiValue.getValues().get(1)).getLongName());
        Assert.assertEquals((Object)"TC1000 Green", (Object)((EnumValue)attributeValueEnumerationMultiValue.getValues().get(2)).getLongName());
    }
}

