/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic.gmm;

import java.util.Iterator;
import java.util.Observable;
import java.util.TreeSet;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.provider.generic.gmm.Member;
import org.eclipse.ecf.provider.generic.gmm.MemberChanged;

public class GMMImpl
extends Observable {
    TreeSet mySet = new TreeSet();

    public boolean addMember(Member m) {
        boolean res = this.mySet.add(m);
        if (res) {
            this.setChanged();
            this.notifyObservers(new MemberChanged(m, true));
        }
        return res;
    }

    public boolean removeMember(Member m) {
        boolean res = this.mySet.remove(m);
        if (res) {
            this.setChanged();
            this.notifyObservers(new MemberChanged(m, false));
        }
        return res;
    }

    public void removeAllMembers() {
        Object[] members = this.getMembers();
        int i = 0;
        while (i < members.length) {
            this.removeMember((Member)members[i]);
            ++i;
        }
    }

    public Object[] getMembers() {
        return this.mySet.toArray();
    }

    public ID[] getMemberIDs(ID exclude) {
        TreeSet newSet = null;
        if (exclude != null) {
            newSet = (TreeSet)this.mySet.clone();
            newSet.remove(new Member(exclude));
        } else {
            newSet = this.mySet;
        }
        ID[] ids = new ID[newSet.size()];
        Iterator iter = newSet.iterator();
        int j = 0;
        while (iter.hasNext()) {
            ids[j++] = ((Member)iter.next()).getID();
        }
        return ids;
    }

    public int getSize() {
        return this.mySet.size();
    }

    public boolean containsMember(Member m) {
        return this.mySet.contains(m);
    }

    public Iterator iterator() {
        return this.mySet.iterator();
    }

    public String toString() {
        return this.mySet.toString();
    }
}

