/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.internal.example.collab.ClientEntry;
import org.eclipse.ecf.internal.example.collab.CollabClient;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class OpenSharedEditorAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private IFile file;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    protected ClientEntry isConnected(IResource res) {
        if (res == null) {
            return null;
        }
        CollabClient client = CollabClient.getDefault();
        ClientEntry entry = client.isConnected(res, "ecf.generic.client");
        return entry;
    }

    public void run(IAction action) {
        if (this.file == null) {
            return;
        }
        IProject project = this.file.getProject();
        ClientEntry entry = this.isConnected((IResource)project);
        if (entry == null) {
            MessageDialog.openInformation((Shell)this.targetPart.getSite().getWorkbenchWindow().getShell(), (String)Messages.OpenSharedEditorAction_DIALOG_NOT_CONNECTED_TITLE, (String)NLS.bind((String)Messages.OpenSharedEditorAction_DIALOG_NOT_CONNECTED_TEXT, (Object)project.getName()));
            return;
        }
        EclipseCollabSharedObject collabsharedobject = entry.getSharedObject();
        if (collabsharedobject != null) {
            collabsharedobject.sendLaunchEditorForFile(null, this.file.getProjectRelativePath().toString());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        this.file = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object obj = ss.getFirstElement();
            if (obj instanceof IFile) {
                this.file = (IFile)obj;
                action.setEnabled(true);
            } else if (obj instanceof IAdaptable) {
                this.file = (IFile)((IAdaptable)obj).getAdapter(IFile.class);
                if (this.file != null) {
                    action.setEnabled(true);
                }
            }
        }
    }
}

