/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.messages;

import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class TimeOffsetMessage
extends RemoteOSGiMessage {
    private long[] timeSeries;

    public TimeOffsetMessage() {
        super((short)8);
        this.timeSeries = new long[0];
    }

    public TimeOffsetMessage(ObjectInputStream input) throws IOException {
        super((short)8);
        int size = input.readInt();
        this.timeSeries = new long[size];
        int i = 0;
        while (i < size) {
            this.timeSeries[i] = input.readLong();
            ++i;
        }
    }

    @Override
    public void writeBody(ObjectOutputStream out) throws IOException {
        out.writeInt(this.timeSeries.length);
        int i = 0;
        while (i < this.timeSeries.length) {
            out.writeLong(this.timeSeries[i]);
            ++i;
        }
    }

    public void timestamp() {
        int len = this.timeSeries.length;
        long[] newSeries = new long[len + 1];
        System.arraycopy(this.timeSeries, 0, newSeries, 0, len);
        newSeries[len] = System.currentTimeMillis();
        this.timeSeries = newSeries;
    }

    public void restamp(int newXID) {
        this.xid = newXID;
        this.timeSeries[this.timeSeries.length - 1] = System.currentTimeMillis();
    }

    public final long[] getTimeSeries() {
        return this.timeSeries;
    }

    public final void setTimeSeries(long[] series) {
        this.timeSeries = series;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TIME_OFFSET, ");
        buffer.append("] - XID: ");
        buffer.append(this.xid);
        buffer.append("timeSeries: [");
        int i = 0;
        while (i < this.timeSeries.length) {
            buffer.append(this.timeSeries[i]);
            if (i < this.timeSeries.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append("]");
        i = 0;
        while (i < this.timeSeries.length) {
            buffer.append(this.timeSeries[i]);
            buffer.append(", ");
            ++i;
        }
        return buffer.toString();
    }
}

