/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLServerSocket;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.provider.comm.IConnectRequestHandler;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.generic.SSLServerSOContainerGroup;
import org.eclipse.ecf.provider.generic.ServerSOContainer;

public class SSLServerSOContainer
extends ServerSOContainer
implements IConnectRequestHandler {
    public static final String DEFAULT_PROTOCOL = "ecfssl";
    public static final int DEFAULT_PORT = Integer.parseInt(System.getProperty("org.eclipse.ecf.provider.generic.secure.port", "4282"));
    public static final int DEFAULT_KEEPALIVE = Integer.parseInt(System.getProperty("org.eclipse.ecf.provider.generic.secure.keepalive", "30000"));
    public static final String DEFAULT_NAME = System.getProperty("org.eclipse.ecf.provider.generic.secure.name", "/secureserver");
    public static String DEFAULT_HOST = System.getProperty("org.eclipse.ecf.provider.generic.secure.host", "localhost");
    public static final boolean DEFAULT_FALLBACK_PORT = Boolean.valueOf(System.getProperty("org.eclipse.ecf.provider.generic.secure.port.fallback", "true"));
    protected int keepAlive;
    protected SSLServerSOContainerGroup group;
    protected boolean isSingle = false;

    static {
        Boolean useHostname = Boolean.valueOf(System.getProperty("org.eclipse.ecf.provider.generic.secure.host.useHostName", "true"));
        if (useHostname.booleanValue()) {
            try {
                DEFAULT_HOST = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                DEFAULT_HOST = "localhost";
            }
        }
    }

    protected int getKeepAlive() {
        return this.keepAlive;
    }

    public static String getServerURL(String host, String name) {
        return "ecfssl://" + host + ":" + DEFAULT_PORT + name;
    }

    public static String getDefaultServerURL() {
        return SSLServerSOContainer.getServerURL("localhost", DEFAULT_NAME);
    }

    public SSLServerSOContainer(ISharedObjectContainerConfig config, int port, InetAddress bindAddress, String path, int keepAlive) throws IOException {
        super(config);
        this.isSingle = true;
        this.keepAlive = keepAlive;
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        this.group = new SSLServerSOContainerGroup(SSLServerSOContainerGroup.DEFAULT_GROUP_NAME, null, 50, port, bindAddress);
        this.group.add(path, this);
        this.group.putOnTheAir();
    }

    public SSLServerSOContainer(ISharedObjectContainerConfig config, SSLServerSocket sslServerSocket, int keepAlive) throws IOException, URISyntaxException {
        super(config);
        this.keepAlive = keepAlive;
        URI actualURI = new URI(this.getID().getName());
        String path = actualURI.getPath();
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        this.group = new SSLServerSOContainerGroup(SSLServerSOContainerGroup.DEFAULT_GROUP_NAME, null, sslServerSocket);
        this.group.add(path, this);
        this.group.putOnTheAir();
    }

    public SSLServerSOContainer(ISharedObjectContainerConfig config, InetAddress bindAddress, int keepAlive) throws IOException, URISyntaxException {
        super(config);
        this.keepAlive = keepAlive;
        this.isSingle = true;
        URI actualURI = new URI(this.getID().getName());
        int port = actualURI.getPort();
        String path = actualURI.getPath();
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        this.group = new SSLServerSOContainerGroup(SSLServerSOContainerGroup.DEFAULT_GROUP_NAME, null, port, 50, bindAddress);
        this.group.add(path, this);
        this.group.putOnTheAir();
    }

    public SSLServerSOContainer(ISharedObjectContainerConfig config, SSLServerSOContainerGroup grp, int keepAlive) throws IOException, URISyntaxException {
        super(config);
        this.keepAlive = keepAlive;
        URI actualURI = new URI(this.getID().getName());
        int urlPort = actualURI.getPort();
        String path = actualURI.getPath();
        if (grp == null) {
            this.isSingle = true;
            this.group = new SSLServerSOContainerGroup(urlPort);
        } else {
            this.group = grp;
        }
        this.group.add(path, this);
        if (grp == null) {
            this.group.putOnTheAir();
        }
    }

    public SSLServerSOContainer(ISharedObjectContainerConfig config, SSLServerSOContainerGroup listener, String path, int keepAlive) {
        super(config);
        this.initialize(listener, path, keepAlive);
    }

    protected void initialize(SSLServerSOContainerGroup listener, String path, int ka) {
        this.keepAlive = ka;
        this.group = listener;
        this.group.add(path, this);
    }

    public void dispose() {
        URI aURI = null;
        try {
            aURI = new URI(this.getID().getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.group.remove(aURI.getPath());
        if (this.isSingle) {
            this.group.takeOffTheAir();
        }
        super.dispose();
    }

    public SSLServerSOContainer(ISharedObjectContainerConfig config) throws IOException, URISyntaxException {
        this(config, (SSLServerSOContainerGroup)null, DEFAULT_KEEPALIVE);
    }

    public SSLServerSOContainer(ISharedObjectContainerConfig config, int keepAlive) throws IOException, URISyntaxException {
        this(config, (SSLServerSOContainerGroup)null, keepAlive);
    }

    public Serializable handleConnectRequest(Socket socket, String target, Serializable data, ISynchAsynchConnection conn) {
        return this.acceptNewClient(socket, target, data, conn);
    }

    protected Serializable getConnectDataFromInput(Serializable input) throws Exception {
        return input;
    }
}

