/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.zookeeper.Version;
import org.apache.zookeeper.jmx.ZKMBeanInfo;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperServerMXBean;

public class ZooKeeperServerBean
implements ZooKeeperServerMXBean,
ZKMBeanInfo {
    private final Date startTime = new Date();
    private final String name;
    protected final ZooKeeperServer zks;

    public ZooKeeperServerBean(ZooKeeperServer zks) {
        this.zks = zks;
        this.name = "StandaloneServer_port" + zks.getClientPort();
    }

    public String getClientPort() {
        try {
            return InetAddress.getLocalHost().getHostAddress() + ":" + this.zks.getClientPort();
        }
        catch (UnknownHostException e) {
            return "localhost:" + this.zks.getClientPort();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return false;
    }

    public String getStartTime() {
        return this.startTime.toString();
    }

    public String getVersion() {
        return Version.getFullVersion();
    }

    public long getAvgRequestLatency() {
        return this.zks.serverStats().getAvgLatency();
    }

    public long getMaxRequestLatency() {
        return this.zks.serverStats().getMaxLatency();
    }

    public long getMinRequestLatency() {
        return this.zks.serverStats().getMinLatency();
    }

    public long getOutstandingRequests() {
        return this.zks.serverStats().getOutstandingRequests();
    }

    public int getTickTime() {
        return this.zks.getTickTime();
    }

    public void setTickTime(int tickTime) {
        this.zks.setTickTime(tickTime);
    }

    public int getMaxClientCnxnsPerHost() {
        NIOServerCnxn.Factory fac = this.zks.getServerCnxnFactory();
        if (fac == null) {
            return -1;
        }
        return fac.getMaxClientCnxns();
    }

    public void setMaxClientCnxnsPerHost(int max) {
        this.zks.getServerCnxnFactory().maxClientCnxns = max;
    }

    public int getMinSessionTimeout() {
        return this.zks.getMinSessionTimeout();
    }

    public void setMinSessionTimeout(int min) {
        this.zks.setMinSessionTimeout(min);
    }

    public int getMaxSessionTimeout() {
        return this.zks.getMaxSessionTimeout();
    }

    public void setMaxSessionTimeout(int max) {
        this.zks.setMaxSessionTimeout(max);
    }

    public long getPacketsReceived() {
        return this.zks.serverStats().getPacketsReceived();
    }

    public long getPacketsSent() {
        return this.zks.serverStats().getPacketsSent();
    }

    public void resetLatency() {
        this.zks.serverStats().resetLatency();
    }

    public void resetMaxLatency() {
        this.zks.serverStats().resetMaxLatency();
    }

    public void resetStatistics() {
        ServerStats serverStats = this.zks.serverStats();
        serverStats.resetRequestCounters();
        serverStats.resetLatency();
    }
}

