/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework.wiring;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.ecf.mgmt.framework.resource.WireMTO;
import org.eclipse.ecf.mgmt.framework.resource.WiringMTO;
import org.eclipse.ecf.mgmt.framework.wiring.BundleRevisionMTO;
import org.eclipse.ecf.mgmt.framework.wiring.BundleWireMTO;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.dto.BundleWireDTO;
import org.osgi.framework.wiring.dto.BundleWiringDTO;
import org.osgi.resource.dto.WireDTO;
import org.osgi.resource.dto.WiringDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleWiringMTO
implements Serializable {
    private static final long serialVersionUID = 5685946064502260512L;
    private long bundle;
    private int root;
    private NodeMTO[] nodes;
    private BundleRevisionMTO[] resources;

    public static BundleWiringMTO[] createMTOs(Bundle b) {
        BundleWiringDTO[] dtos = (BundleWiringDTO[])b.adapt(BundleWiringDTO[].class);
        ArrayList<BundleWiringMTO> results = new ArrayList<BundleWiringMTO>(dtos.length);
        BundleWiringDTO[] bundleWiringDTOArray = dtos;
        int n = dtos.length;
        int n2 = 0;
        while (n2 < n) {
            BundleWiringDTO dto = bundleWiringDTOArray[n2];
            results.add(new BundleWiringMTO(dto));
            ++n2;
        }
        return results.toArray(new BundleWiringMTO[results.size()]);
    }

    public static BundleWiringMTO createMTO(BundleWiringDTO dto) {
        return new BundleWiringMTO(dto);
    }

    BundleWiringMTO(BundleWiringDTO dto) {
        this.bundle = dto.bundle;
        this.root = dto.root;
        this.nodes = BundleWiringMTO.createNodeMTOs(dto.nodes);
        this.resources = BundleRevisionMTO.createMTOs(dto.resources);
    }

    public long getBundle() {
        return this.bundle;
    }

    public int getRoot() {
        return this.root;
    }

    public NodeMTO[] getNodes() {
        return this.nodes;
    }

    public BundleRevisionMTO[] getResources() {
        return this.resources;
    }

    public String toString() {
        return "BundleWiringMTO [bundle=" + this.bundle + ", root=" + this.root + ", nodes=" + Arrays.toString(this.nodes) + ", resources=" + Arrays.toString(this.resources) + "]";
    }

    public static NodeMTO[] createNodeMTOs(Set<BundleWiringDTO.NodeDTO> dtos) {
        ArrayList<NodeMTO> results = new ArrayList<NodeMTO>(dtos.size());
        for (BundleWiringDTO.NodeDTO dto : dtos) {
            results.add(new NodeMTO(dto));
        }
        return results.toArray(new NodeMTO[results.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeMTO
    extends WiringMTO {
        private static final long serialVersionUID = 2290401090833912940L;
        private boolean inUse;
        private boolean current;

        public NodeMTO(BundleWiringDTO.NodeDTO dto) {
            super((WiringDTO)dto);
            this.inUse = dto.inUse;
            this.current = dto.current;
        }

        public boolean isInUse() {
            return this.inUse;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public String toString() {
            return "NodeMTO [inUse=" + this.inUse + ", current=" + this.current + ", id=" + this.getId() + ", capabilities=" + Arrays.toString(this.getCapabilities()) + ", requirements=" + Arrays.toString(this.getRequirements()) + ", providedWires=" + Arrays.toString(this.getProvidedWires()) + ", requiredWires=" + Arrays.toString(this.getRequiredWires()) + ", resource=" + this.getResource() + "]";
        }

        @Override
        protected WireMTO[] createMTOs(List<WireDTO> dtos) {
            ArrayList<BundleWireMTO> results = new ArrayList<BundleWireMTO>(dtos.size());
            for (WireDTO dto : dtos) {
                results.add(new BundleWireMTO((BundleWireDTO)dto));
            }
            return results.toArray(new BundleWireMTO[results.size()]);
        }
    }
}

