/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.remoteservice.util.IDUtil;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointDescriptionPropertiesUtil {
    public static String verifyStringProperty(Map<String, Object> properties, String propName) {
        if (properties == null) {
            return null;
        }
        Object r = properties.get(propName);
        try {
            return (String)r;
        }
        catch (ClassCastException e) {
            IllegalArgumentException iae = new IllegalArgumentException("property value is not a String: " + propName);
            iae.initCause(e);
            throw iae;
        }
    }

    public static Long verifyLongProperty(Map<String, Object> properties, String propName) {
        if (properties == null) {
            return null;
        }
        Object r = properties.get(propName);
        try {
            return (Long)r;
        }
        catch (ClassCastException e) {
            IllegalArgumentException iae = new IllegalArgumentException("property value is not a Long: " + propName);
            iae.initCause(e);
            throw iae;
        }
    }

    public static ID verifyIDProperty(String idNamespace, String idName) {
        if (idName == null) {
            return null;
        }
        try {
            return IDUtil.createID(idNamespace, idName);
        }
        catch (IDCreateException iDCreateException) {
            return IDFactory.getDefault().createStringID(idName);
        }
    }

    public static List getStringPlusProperty(Map properties, String key) {
        Object value = properties.get(key);
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof String) {
            return Collections.singletonList((String)value);
        }
        if (value instanceof String[]) {
            String[] values = (String[])value;
            ArrayList<String> result = new ArrayList<String>(values.length);
            int i = 0;
            while (i < values.length) {
                if (values[i] != null) {
                    result.add(values[i]);
                }
                ++i;
            }
            return Collections.unmodifiableList(result);
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            ArrayList<String> result = new ArrayList<String>(values.size());
            for (Object v : values) {
                if (!(v instanceof String)) continue;
                result.add((String)v);
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.EMPTY_LIST;
    }

    public static ID[] verifyIDArray(Map<String, Object> properties, String propName, String idNamespace) {
        List idNames = EndpointDescriptionPropertiesUtil.getStringPlusProperty(properties, propName);
        if (idNames.size() == 0) {
            return null;
        }
        ArrayList<ID> results = new ArrayList<ID>();
        for (String idName : idNames) {
            try {
                results.add(IDUtil.createID(idNamespace, idName));
            }
            catch (IDCreateException e) {
                IllegalArgumentException iae = new IllegalArgumentException("cannot create ID[]: idNamespace=" + idNamespace + " idName=" + idName);
                iae.initCause(e);
                throw iae;
            }
        }
        return results.toArray(new ID[results.size()]);
    }

    public static Version getPackageVersion(Map<String, Object> endpointDescriptionProperties, String packageName) {
        String version;
        String key = "endpoint.package.version." + packageName;
        Object value = endpointDescriptionProperties.get(key);
        try {
            version = (String)value;
        }
        catch (ClassCastException e) {
            IllegalArgumentException iae = new IllegalArgumentException(String.valueOf(key) + " property value not a String");
            iae.initCause(e);
            throw iae;
        }
        return Version.parseVersion((String)version);
    }

    public static List<String> verifyObjectClassProperty(Map<String, Object> endpointDescriptionProperties) {
        Object o = endpointDescriptionProperties.get("objectClass");
        if (!(o instanceof String[])) {
            throw new IllegalArgumentException("objectClass value must be of type String[]");
        }
        String[] obClass = (String[])o;
        if (obClass.length < 1) {
            throw new IllegalArgumentException("objectClass is empty");
        }
        String[] stringArray = obClass;
        int n = obClass.length;
        int n2 = 0;
        while (n2 < n) {
            String intf = stringArray[n2];
            int index = intf.lastIndexOf(46);
            if (index != -1) {
                String packageName = intf.substring(0, index);
                try {
                    EndpointDescriptionPropertiesUtil.getPackageVersion(endpointDescriptionProperties, packageName);
                }
                catch (IllegalArgumentException e) {
                    IllegalArgumentException iae = new IllegalArgumentException("Bad version for package " + packageName);
                    iae.initCause(e);
                    throw iae;
                }
            }
            ++n2;
        }
        return Collections.unmodifiableList(Arrays.asList(obClass));
    }

    public static Dictionary createDictionaryFromMap(Map propMap) {
        if (propMap == null) {
            return null;
        }
        Properties result = new Properties();
        for (Object key : propMap.keySet()) {
            Object val = propMap.get(key);
            if (key == null || val == null) continue;
            ((Dictionary)result).put(key, val);
        }
        return result;
    }
}

