/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.AggregateEntityMapHolder;
import org.eclipse.persistence.testing.models.collections.map.AggregateMapKey;
import org.eclipse.persistence.testing.models.collections.map.EntityMapValue;

public class TestReadAggregateEntityMapMapping
extends TestCase {
    private List holders = null;
    protected int fetchJoinRelationship = 0;
    protected int oldFetchJoinValue = 0;
    protected ManyToManyMapping mapping = null;
    protected Expression holderExp;

    public TestReadAggregateEntityMapMapping() {
    }

    public TestReadAggregateEntityMapMapping(int fetchJoin) {
        this();
        this.fetchJoinRelationship = fetchJoin;
        this.setName("TestReadAggregateEntityMapMapping fetchJoin = " + fetchJoin);
    }

    public void setup() {
        this.mapping = (ManyToManyMapping)this.getSession().getProject().getDescriptor(AggregateEntityMapHolder.class).getMappingForAttributeName("aggregateToEntityMap");
        this.oldFetchJoinValue = this.mapping.getJoinFetch();
        this.mapping.setJoinFetch(this.fetchJoinRelationship);
        this.getSession().getProject().getDescriptor(AggregateEntityMapHolder.class).reInitializeJoinedAttributes();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        AggregateEntityMapHolder holder = new AggregateEntityMapHolder();
        EntityMapValue value = new EntityMapValue();
        value.setId(1);
        AggregateMapKey key = new AggregateMapKey();
        key.setKey(11);
        holder.addAggregateToEntityMapItem(key, value);
        EntityMapValue value2 = new EntityMapValue();
        value2.setId(2);
        key = new AggregateMapKey();
        key.setKey(22);
        holder.addAggregateToEntityMapItem(key, value2);
        uow.registerObject((Object)holder);
        uow.registerObject((Object)value);
        uow.registerObject((Object)value2);
        uow.commit();
        this.holderExp = new ExpressionBuilder().get("id").equal(holder.getId());
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        this.holders = this.getSession().readAllObjects(AggregateEntityMapHolder.class, this.holderExp);
    }

    public void verify() {
        if (this.holders == null || this.holders.size() != 1) {
            throw new TestErrorException("Incorrect number of MapHolders was read.");
        }
        AggregateEntityMapHolder holder = (AggregateEntityMapHolder)this.holders.get(0);
        if (!((IndirectMap)holder.getAggregateToEntityMap()).getValueHolder().isInstantiated() && this.fetchJoinRelationship > 0) {
            throw new TestErrorException("Relationship was not properly joined.");
        }
        if (holder.getAggregateToEntityMap().size() != 2) {
            throw new TestErrorException("Incorrect Number of MapEntityValues was read.");
        }
        AggregateMapKey mapKey = new AggregateMapKey();
        mapKey.setKey(11);
        EntityMapValue value = (EntityMapValue)holder.getAggregateToEntityMap().get(mapKey);
        if (value.getId() != 1) {
            throw new TestErrorException("Incorrect MapEntityValues was read.");
        }
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        for (AggregateEntityMapHolder holder : this.holders) {
            Iterator j = holder.getAggregateToEntityMap().keySet().iterator();
            while (j.hasNext()) {
                uow.deleteObject(holder.getAggregateToEntityMap().get(j.next()));
            }
        }
        uow.deleteAllObjects((Collection)this.holders);
        uow.commit();
        if (!this.verifyDelete(this.holders.get(0))) {
            throw new TestErrorException("Delete was unsuccessful.");
        }
        this.mapping.setJoinFetch(this.oldFetchJoinValue);
    }
}

