/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import java.util.Hashtable;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;
import org.eclipse.persistence.testing.tests.isolatedsession.IsolatedEmployee;

public class IsolatedObjectNotSentTest
extends ConfigurableCacheSyncDistributedTest {
    protected IsolatedEmployee employee = null;
    protected Expression expression = null;
    protected IsolatedEmployee distributedEmployee = null;
    public boolean sentChanges = false;
    protected SessionEventAdapter listener;

    public IsolatedObjectNotSentTest() {
        this.setDescription("Test to ensure that objects that are set as isolated will not be sent over Cache Synchronization.");
    }

    public IsolatedObjectNotSentTest(Hashtable cacheSyncConfigValues) {
        this.setDescription("Test to ensure that objects that are set as isolated will not be sent over Cache Synchronization.");
    }

    @Override
    public void setup() {
        super.setup();
        ExpressionBuilder employees = new ExpressionBuilder();
        this.expression = employees.get("firstName").equal((Object)"Andy");
        this.expression = this.expression.and(employees.get("lastName").equal((Object)"McDurmont"));
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().get(0);
        this.distributedEmployee = (IsolatedEmployee)server.getDistributedSession().readObject(IsolatedEmployee.class, this.expression);
        this.listener = new SessionEventAdapter(){

            public void preMergeUnitOfWorkChangeSet(SessionEvent event) {
                IsolatedObjectNotSentTest.this.sentChanges = true;
            }
        };
        server.getDistributedSession().getEventManager().addListener((SessionEventListener)this.listener);
        this.sentChanges = false;
    }

    public void test() {
        this.employee = (IsolatedEmployee)this.getSession().readObject(IsolatedEmployee.class, this.expression);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        IsolatedEmployee employeeClone = (IsolatedEmployee)uow.registerObject((Object)this.employee);
        employeeClone.setSalary(employeeClone.getSalary() + 1000);
        uow.commit();
    }

    public void verify() {
        this.distributedEmployee = (IsolatedEmployee)this.getObjectFromDistributedCache(this.employee);
        if (this.distributedEmployee.getSalary() == this.employee.getSalary()) {
            this.throwError("The employee was sent by cache synchronization, but should not have been since it is isolated.");
        }
        if (this.sentChanges) {
            this.throwError("Cache coordintion was sent even though no object were synchronized.");
        }
    }

    @Override
    public void reset() {
        super.reset();
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().get(0);
        server.getDistributedSession().getEventManager().removeListener((SessionEventListener)this.listener);
    }
}

