/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.InMemoryQueryIndirectionPolicy;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class GetAllFromIdentityMapTest
extends TestCase {
    private UnitOfWork uow = null;
    private ReadAllQuery query;

    private static ReadAllQuery newReadAllQuery(Class<?> c) {
        ReadAllQuery query = new ReadAllQuery(c);
        query.conformResultsInUnitOfWork();
        query.setInMemoryQueryIndirectionPolicy(new InMemoryQueryIndirectionPolicy(1));
        return query;
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.uow = this.getSession().acquireUnitOfWork();
        this.query = GetAllFromIdentityMapTest.newReadAllQuery(Employee.class);
        ExpressionBuilder emp = new ExpressionBuilder();
        this.query.setSelectionCriteria(emp.get("manager").get("firstName").equal((Object)"Bob"));
        this.uow.executeQuery((DatabaseQuery)this.query);
    }

    public void reset() {
        this.uow.release();
        this.uow = null;
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() throws Throwable {
        Vector employees = (Vector)this.uow.executeQuery((DatabaseQuery)this.query);
        GetAllFromIdentityMapTest.assertFalse((boolean)employees.isEmpty());
        for (Employee employee : employees) {
            GetAllFromIdentityMapTest.assertEquals((String)"Bob", (String)employee.getManager().getFirstName());
        }
    }
}

