/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.tests.remote.TransporterGenerator;

public class RemoteConnectionExceptionsTest
extends TestCase {
    protected Class remoteConnectionClass;
    private RemoteConnection remoteConnection;
    protected TransporterGenerator generator;
    protected Object[] results;
    protected Throwable[] exceptions;
    protected Hashtable knownBugs;
    protected Vector namesToExclude;
    protected Vector methods;
    protected Vector args;

    public RemoteConnectionExceptionsTest(int mode, Class remoteConnectionClass) {
        this.remoteConnectionClass = remoteConnectionClass;
        this.generator = new TransporterGenerator(mode);
        this.setNameAndCheckMode();
        this.setNamesToExclude();
        this.setMethodsAndArgs();
        this.setKnownBugs();
    }

    public RemoteConnectionExceptionsTest(int mode, String remoteConnectionClassName) throws ClassNotFoundException {
        this(mode, Class.forName(remoteConnectionClassName));
    }

    protected void setRemoteConnection(RemoteConnection remoteConnection) {
        Class<?> cls = remoteConnection.getClass();
        if (!this.remoteConnectionClass.equals(cls)) {
            throw new TestProblemException("remoteConnection's type is different from the type used to create the test");
        }
        this.remoteConnection = remoteConnection;
        this.remoteConnection.setSession((DistributedSession)new RemoteSession());
    }

    protected RemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    protected void setNamesToExclude() {
        this.namesToExclude = new Vector();
        String[] namesToExcludeArray = new String[]{"createProxySession", "createRemoteSession", "cursoredStreamNextPage", "fixObjectReferences", "getRemoteSessionController", "setRemoteSessionController"};
        for (int i = 0; i < namesToExcludeArray.length; ++i) {
            this.namesToExclude.add(namesToExcludeArray[i]);
        }
    }

    protected void setNameAndCheckMode() throws TestProblemException {
        int mode = this.generator.getMode();
        String className = this.remoteConnectionClass.getName();
        if (mode == TransporterGenerator.THROW_REMOTE_EXCEPTION) {
            this.setName(this.getName().concat(" THROW_REMOTE_EXCEPTION"));
            this.setDescription("Verifies that CommunicationException are thrown by methods of " + className + " class");
        } else if (mode == TransporterGenerator.SET_EXCEPTION_INTO_TRANSPORTER) {
            this.setName(this.getName().concat(" SET_EXCEPTION_INTO_TRANSPORTER"));
            this.setDescription("Verifies that Transporter.getException() are thrown by methods of " + className + " class");
        } else {
            throw new TestProblemException("Unsupported mode");
        }
    }

    protected void setMethodsAndArgs() {
        this.methods = new Vector();
        this.args = new Vector();
        Method[] allMethods = this.remoteConnectionClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Method method = allMethods[i];
            if (!method.getDeclaringClass().equals(this.remoteConnectionClass) || !Modifier.isPublic(method.getModifiers())) continue;
            String name = method.getName();
            if (this.namesToExclude != null && this.namesToExclude.contains(name)) continue;
            this.methods.add(method);
            Class<?>[] types = method.getParameterTypes();
            Object[] params = new Object[types.length];
            for (int j = 0; j < types.length; ++j) {
                Class<?> type = types[j];
                if (!type.isPrimitive()) continue;
                params[j] = RemoteConnectionExceptionsTest.getWrapperClassInstance(type);
            }
            this.args.add(params);
        }
    }

    protected void setKnownBugs() {
        this.knownBugs = new Hashtable();
        if (this.generator.getMode() == TransporterGenerator.SET_EXCEPTION_INTO_TRANSPORTER) {
            for (int i = 0; i < this.methods.size(); ++i) {
                Method method = (Method)this.methods.elementAt(i);
                Object[] params = (Object[])this.args.elementAt(i);
                String name = method.getName();
                if (!name.equals("cursorSelectObjects") || params.length != 2) continue;
                this.knownBugs.put(method, "bug 2909926");
            }
        }
    }

    protected String getNameToBind() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected boolean isCorrect(int i) {
        boolean ok;
        Throwable exception = this.exceptions[i];
        int mode = this.generator.getMode();
        if (mode == TransporterGenerator.THROW_REMOTE_EXCEPTION) {
            boolean bl = ok = exception != null;
            if (ok && (ok = CommunicationException.class.isInstance(exception))) {
                boolean bl2 = ok = ((CommunicationException)exception).getErrorCode() == 12003;
            }
            if (!ok && ((Method)this.methods.elementAt(i)).getName().equals("isConnected") && Boolean.class.isInstance(this.results[i])) {
                ok = (Boolean)this.results[i] == false;
            }
        } else if (mode == TransporterGenerator.SET_EXCEPTION_INTO_TRANSPORTER) {
            boolean bl = ok = exception != null;
            if (ok && (ok = TestException.class.isInstance(exception))) {
                ok = ((TestException)exception).getMessage().endsWith(this.generator.getMessage());
            }
        } else {
            throw new TestException("Unsupported mode");
        }
        return ok;
    }

    public void test() throws Exception {
        this.results = new Object[this.methods.size()];
        this.exceptions = new Throwable[this.methods.size()];
        for (int i = 0; i < this.methods.size(); ++i) {
            Method method = (Method)this.methods.elementAt(i);
            Object[] params = (Object[])this.args.elementAt(i);
            Object result = null;
            Throwable exception = null;
            try {
                result = method.invoke((Object)this.getRemoteConnection(), params);
            }
            catch (InvocationTargetException ex) {
                exception = ex.getTargetException();
            }
            this.results[i] = result;
            this.exceptions[i] = exception;
        }
    }

    public void verify() {
        boolean errorHasOccured = false;
        String errorMessage = new String("Wrong exception/result thrown/returned by methods:");
        String unknownBug = new String("!!!UNKNOWN BUG!!!");
        for (int i = 0; i < this.methods.size(); ++i) {
            String knownBug;
            Method method = (Method)this.methods.elementAt(i);
            String name = method.getName();
            if (this.isCorrect(i)) continue;
            errorHasOccured = true;
            errorMessage = errorMessage.concat(" ");
            errorMessage = errorMessage.concat(name);
            errorMessage = errorMessage.concat("(");
            String bug = unknownBug;
            if (this.knownBugs != null && !this.knownBugs.isEmpty() && (knownBug = (String)this.knownBugs.get(this.methods.elementAt(i))) != null) {
                bug = knownBug;
            }
            errorMessage = errorMessage.concat(bug);
            errorMessage = errorMessage.concat(")");
            errorMessage = errorMessage.concat(";");
        }
        if (errorHasOccured) {
            throw new TestErrorException(errorMessage);
        }
    }

    public static Object getWrapperClassInstance(Class cls) {
        if (Integer.TYPE.equals(cls)) {
            return 0;
        }
        if (Boolean.TYPE.equals(cls)) {
            return false;
        }
        if (Character.TYPE.equals(cls)) {
            return Character.valueOf(' ');
        }
        if (Byte.TYPE.equals(cls)) {
            byte b = 0;
            return b;
        }
        if (Short.TYPE.equals(cls)) {
            short s = 0;
            return s;
        }
        if (Long.TYPE.equals(cls)) {
            return 0L;
        }
        if (Float.TYPE.equals(cls)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(cls)) {
            return 0.0;
        }
        return null;
    }
}

