/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigProject_11_1_1;
import org.eclipse.persistence.internal.sessions.factories.XMLSessionConfigWriter;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.log.DefaultSessionLogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DatabaseLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.CustomServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.ServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.PoolsConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ReadConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.WriteConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectClassConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.property.PropertyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.rcm.RemoteCommandManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.ServerSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.JMSTopicTransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.TransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.naming.JNDINamingServiceConfig;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SessionsXMLSchemaWriteTest
extends AutoVerifyTestCase {
    private File m_resource;
    private DatabaseSessionConfig m_session;

    public SessionsXMLSchemaWriteTest() {
        this.setDescription("Test the writing portion of the session xml against the XML Schema");
    }

    public void reset() {
    }

    protected void setup() throws Exception {
        this.m_resource = new File("XMLSchemaWriteTest.xml");
        SessionConfigs sessions = new SessionConfigs();
        DatabaseSessionConfig dbSessionConfig = new DatabaseSessionConfig();
        dbSessionConfig.setExceptionHandlerClass("handlerClass");
        CustomServerPlatformConfig platformConfig = new CustomServerPlatformConfig();
        platformConfig.setExternalTransactionControllerClass("externalTransactionController");
        dbSessionConfig.setServerPlatformConfig((ServerPlatformConfig)platformConfig);
        DefaultSessionLogConfig logConfig = new DefaultSessionLogConfig();
        logConfig.setLogLevel("severe");
        logConfig.setFilename("logfile");
        dbSessionConfig.setLogConfig((LogConfig)logConfig);
        DatabaseLoginConfig loginConfig = new DatabaseLoginConfig();
        loginConfig.setBatchWriting(true);
        loginConfig.setBindAllParameters(true);
        loginConfig.setByteArrayBinding(false);
        loginConfig.setCacheAllStatements(false);
        loginConfig.setConnectionURL("jdbc:oracle:thin:@otl-ora8infmx73:1521:toplinkj");
        loginConfig.setDriverClass("oracle.jdbc.OracleDriver");
        loginConfig.setExternalConnectionPooling(false);
        loginConfig.setExternalTransactionController(false);
        loginConfig.setForceFieldNamesToUppercase(false);
        loginConfig.setJdbcBatchWriting(false);
        loginConfig.setMaxBatchWritingSize(Integer.valueOf(5));
        loginConfig.setNativeSequencing(false);
        loginConfig.setNativeSQL(false);
        loginConfig.setOptimizeDataConversion(true);
        loginConfig.setPassword("password");
        loginConfig.setPlatformClass("platform");
        loginConfig.setSequenceCounterField("SEQ_COUNT");
        loginConfig.setSequenceNameField("SEQ_NAME");
        loginConfig.setSequencePreallocationSize(Integer.valueOf(99));
        loginConfig.setSequenceTable("\"SEQUENCE\"");
        loginConfig.setStreamsForBinding(false);
        loginConfig.setStringBinding(false);
        loginConfig.setTableQualifier("table:");
        loginConfig.setTrimStrings(true);
        loginConfig.setUsername("tljtest1");
        dbSessionConfig.setLoginConfig((LoginConfig)loginConfig);
        dbSessionConfig.setName("EmployeeSession");
        dbSessionConfig.setProfiler("toplink");
        ProjectClassConfig projectConfig = new ProjectClassConfig();
        projectConfig.setProjectString("org.eclipse.persistence.demos.employee.relational.EmployeeProject");
        dbSessionConfig.setPrimaryProject((ProjectConfig)projectConfig);
        RemoteCommandManagerConfig rcmConfig = new RemoteCommandManagerConfig();
        rcmConfig.setChannel("new_channel");
        JMSTopicTransportManagerConfig transportConfig = new JMSTopicTransportManagerConfig();
        transportConfig.setOnConnectionError("KeepConnection");
        transportConfig.setTopicHostURL("ormi://jms_topic_host");
        transportConfig.setTopicConnectionFactoryName("test-topic-connection-factory-name");
        transportConfig.setTopicName("test-topic-name");
        JNDINamingServiceConfig namingConfig = new JNDINamingServiceConfig();
        namingConfig.setURL("new_jndi_url");
        namingConfig.setUsername("guy");
        namingConfig.setPassword("password");
        namingConfig.setInitialContextFactoryName("new_initial_context_factory_name");
        Vector<PropertyConfig> props = new Vector<PropertyConfig>();
        PropertyConfig one = new PropertyConfig();
        one.setName("name1");
        one.setValue("value1");
        props.add(one);
        PropertyConfig two = new PropertyConfig();
        two.setName("name2");
        two.setValue("value2");
        props.add(two);
        namingConfig.setPropertyConfigs(props);
        transportConfig.setJNDINamingServiceConfig(namingConfig);
        rcmConfig.setTransportManagerConfig((TransportManagerConfig)transportConfig);
        dbSessionConfig.setRemoteCommandManagerConfig(rcmConfig);
        dbSessionConfig.setSessionCustomizerClass("sessionCustomizer");
        sessions.addSessionConfig((SessionConfig)dbSessionConfig);
        ServerSessionConfig serverSessionConfig = new ServerSessionConfig();
        serverSessionConfig.setPoolsConfig(new PoolsConfig());
        ReadConnectionPoolConfig readPool = new ReadConnectionPoolConfig();
        readPool.setMaxConnections(Integer.valueOf(2));
        readPool.setMinConnections(Integer.valueOf(2));
        serverSessionConfig.getPoolsConfig().setReadConnectionPoolConfig(readPool);
        WriteConnectionPoolConfig writePool = new WriteConnectionPoolConfig();
        writePool.setMaxConnections(Integer.valueOf(10));
        writePool.setMinConnections(Integer.valueOf(5));
        serverSessionConfig.getPoolsConfig().setWriteConnectionPoolConfig(writePool);
        WriteConnectionPoolConfig userPool = new WriteConnectionPoolConfig();
        userPool.setMaxConnections(Integer.valueOf(5));
        userPool.setMinConnections(Integer.valueOf(0));
        serverSessionConfig.getPoolsConfig().addConnectionPoolConfig((ConnectionPoolConfig)userPool);
        sessions.addSessionConfig((SessionConfig)serverSessionConfig);
        FileWriter writer = new FileWriter(this.m_resource);
        XMLSessionConfigWriter.write((SessionConfigs)sessions, (Writer)writer);
        writer.close();
    }

    public void test() {
        try {
            FileReader reader = new FileReader(this.m_resource);
            XMLContext context = new XMLContext((Project)new XMLSessionConfigProject_11_1_1());
            XMLUnmarshaller unmarshaller = context.createUnmarshaller();
            SessionConfigs eclipseLinkSessions = (SessionConfigs)unmarshaller.unmarshal((Reader)reader);
            this.m_session = (DatabaseSessionConfig)eclipseLinkSessions.getSessionConfigs().firstElement();
        }
        catch (Exception exception) {
            this.m_session = null;
        }
    }

    protected void verify() {
        Vector propertyConfigs;
        ServerPlatformConfig platformConfig;
        if (this.m_session == null) {
            throw new TestErrorException("The session on read back was null");
        }
        this.check("Name", this.m_session.getName(), "EmployeeSession");
        this.check("Profiler", this.m_session.getProfiler(), "toplink");
        if (this.m_session.getPrimaryProject() == null) {
            throw new TestErrorException("ProjectClass was null");
        }
        this.check("ProjectClass", this.m_session.getPrimaryProject().getProjectString(), "org.eclipse.persistence.demos.employee.relational.EmployeeProject");
        this.check("ExceptionHandlerClass", this.m_session.getExceptionHandlerClass(), "handlerClass");
        if (this.m_session.getServerPlatformConfig() != null) {
            platformConfig = this.m_session.getServerPlatformConfig();
            if (!(platformConfig instanceof CustomServerPlatformConfig)) {
                throw new TestErrorException("ServerPlatformConfig not correct type");
            }
        } else {
            throw new TestErrorException("ServerPlatformConfig was null");
        }
        this.check("ExternalTransactionControllerClass", ((CustomServerPlatformConfig)platformConfig).getExternalTransactionControllerClass(), "externalTransactionController");
        this.check("SessionCustomizer", this.m_session.getSessionCustomizerClass(), "sessionCustomizer");
        if (!(this.m_session.getLogConfig() instanceof DefaultSessionLogConfig)) {
            throw new TestErrorException("LogConfig not correct type");
        }
        DefaultSessionLogConfig logConfig = (DefaultSessionLogConfig)this.m_session.getLogConfig();
        this.check("LogLevel", logConfig.getLogLevel(), "severe");
        this.check("Filename", logConfig.getFilename(), "logfile");
        if (!(this.m_session.getLoginConfig() instanceof DatabaseLoginConfig)) {
            throw new TestErrorException("LogConfig not correct type");
        }
        DatabaseLoginConfig loginConfig = (DatabaseLoginConfig)this.m_session.getLoginConfig();
        this.checkBoolean("BatchWriting", loginConfig.getBatchWriting(), true);
        this.checkBoolean("BindAllParameters", loginConfig.getBindAllParameters(), true);
        this.checkBoolean("ByteArrayBinding", loginConfig.getByteArrayBinding(), false);
        this.checkBoolean("CacheAllStatements", loginConfig.getCacheAllStatements(), false);
        this.check("ConnectionURL", loginConfig.getConnectionURL(), "jdbc:oracle:thin:@otl-ora8infmx73:1521:toplinkj");
        this.check("DriverClass", loginConfig.getDriverClass(), "oracle.jdbc.OracleDriver");
        this.checkBoolean("ExternalConnectionPooling", loginConfig.getExternalConnectionPooling(), false);
        this.checkBoolean("ExternalTransactionController", loginConfig.getExternalTransactionController(), false);
        this.checkBoolean("ForceFieldNamesToUppercase", loginConfig.getForceFieldNamesToUppercase(), false);
        this.checkBoolean("JdbcBatchWriting", loginConfig.getJdbcBatchWriting(), false);
        this.check("MaxBatchWritingSize", loginConfig.getMaxBatchWritingSize(), 5);
        this.checkBoolean("NativeSequencing", loginConfig.getNativeSequencing(), false);
        this.checkBoolean("NativeSQL", loginConfig.getNativeSQL(), false);
        this.checkBoolean("OptimizeDataConversion", loginConfig.getOptimizeDataConversion(), true);
        this.check("Password", loginConfig.getPassword(), "password");
        this.check("PlatformClass", loginConfig.getPlatformClass(), "platform");
        this.check("SequenceCounterField", loginConfig.getSequenceCounterField(), "SEQ_COUNT");
        this.check("SequenceNameField", loginConfig.getSequenceNameField(), "SEQ_NAME");
        this.check("SequencePreallocationSize", loginConfig.getSequencePreallocationSize(), 99);
        this.check("SequenceTable", loginConfig.getSequenceTable(), "\"SEQUENCE\"");
        this.checkBoolean("StreamsForBinding", loginConfig.getStreamsForBinding(), false);
        this.checkBoolean("StringBinding", loginConfig.getStringBinding(), false);
        this.check("TableQualifier", loginConfig.getTableQualifier(), "table:");
        this.checkBoolean("TrimStrings", loginConfig.getTrimStrings(), true);
        this.check("Username", loginConfig.getUsername(), "tljtest1");
        RemoteCommandManagerConfig rcmConfig = this.m_session.getRemoteCommandManagerConfig();
        if (rcmConfig == null) {
            throw new TestErrorException("RemoteCommandManagerConfig was null");
        }
        this.check("Channel", rcmConfig.getChannel(), "new_channel");
        if (rcmConfig.getTransportManagerConfig() instanceof JMSTopicTransportManagerConfig) {
            JMSTopicTransportManagerConfig transportConfig = (JMSTopicTransportManagerConfig)rcmConfig.getTransportManagerConfig();
            this.check("OnConnectionError", transportConfig.getOnConnectionError(), "KeepConnection");
            this.check("TopicHostURL", transportConfig.getTopicHostURL(), "ormi://jms_topic_host");
            this.check("TopicConnectionFactoryName", transportConfig.getTopicConnectionFactoryName(), "test-topic-connection-factory-name");
            this.check("TopicName", transportConfig.getTopicName(), "test-topic-name");
            JNDINamingServiceConfig namingConfig = transportConfig.getJNDINamingServiceConfig();
            if (namingConfig == null) {
                throw new TestErrorException("JNDINamingServiceConfig was null");
            }
            this.check("Naming URL", namingConfig.getURL(), "new_jndi_url");
            this.check("Naming Username", namingConfig.getUsername(), "guy");
            this.check("Naming Password", namingConfig.getPassword(), "password");
            this.check("InitialContextFactoryName", namingConfig.getInitialContextFactoryName(), "new_initial_context_factory_name");
            propertyConfigs = namingConfig.getPropertyConfigs();
            if (propertyConfigs == null) {
                throw new TestErrorException("PropertyConfigs were null");
            }
            if (propertyConfigs.size() != 2) {
                throw new TestErrorException("PropertyConfigs were not the correct size");
            }
        } else {
            throw new TestErrorException("TransportManagerConfig not correct type");
        }
        PropertyConfig one = (PropertyConfig)propertyConfigs.firstElement();
        this.check("Property name", one.getName(), "name1");
        this.check("Property value", one.getValue(), "value1");
        PropertyConfig two = (PropertyConfig)propertyConfigs.lastElement();
        this.check("Property name", two.getName(), "name2");
        this.check("Property value", two.getValue(), "value2");
    }

    private void checkBoolean(String name, boolean one, boolean two) {
        if (one != two) {
            throw new TestErrorException("For: " + name + ", expecting: " + one + ", found: " + two);
        }
    }

    private void check(String name, Object one, Object two) {
        if (!one.equals(two)) {
            throw new TestErrorException("For: " + name + ", expecting: " + one + ", found: " + two);
        }
    }
}

