/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.sessionconsole;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.tools.beans.MessageDialog;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;
import org.eclipse.persistence.tools.profiler.Profile;
import org.eclipse.persistence.tools.sessionconsole.ProfileBrowserPanel;

public class ProfileBrowser
extends JFrame {
    private JPanel ivjMainPanel = null;
    private ProfileBrowserPanel ivjProfileBrowserPanel = null;

    public ProfileBrowser() {
        this.initialize();
    }

    public ProfileBrowser(String title) {
        super(title);
    }

    public static void browseProfiler(SessionProfiler profiler) {
        ProfileBrowser.browseProfiles(((PerformanceProfiler)profiler).getProfiles());
    }

    public static void browseProfiles(List<Profile> profiles) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            ProfileBrowser aProfileBrowserFrame = new ProfileBrowser();
            aProfileBrowserFrame.setVisible(true);
            aProfileBrowserFrame.setProfiles(profiles);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JPanel");
            exception.printStackTrace(System.out);
        }
    }

    public static void centerComponent(Component component) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = component.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        component.setLocation(screenSize.width - size.width, screenSize.height - size.height);
    }

    private JPanel getMainPanel() {
        if (this.ivjMainPanel == null) {
            try {
                this.ivjMainPanel = new JPanel();
                this.ivjMainPanel.setName("MainPanel");
                this.ivjMainPanel.setLayout(new GridBagLayout());
                this.ivjMainPanel.setBackground(SystemColor.control);
                GridBagConstraints constraintsProfileBrowserPanel = new GridBagConstraints();
                constraintsProfileBrowserPanel.gridx = 1;
                constraintsProfileBrowserPanel.gridy = 1;
                constraintsProfileBrowserPanel.fill = 1;
                constraintsProfileBrowserPanel.weightx = 1.0;
                constraintsProfileBrowserPanel.weighty = 1.0;
                constraintsProfileBrowserPanel.insets = new Insets(2, 2, 2, 2);
                this.getMainPanel().add((Component)this.getProfileBrowserPanel(), constraintsProfileBrowserPanel);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMainPanel;
    }

    private ProfileBrowserPanel getProfileBrowserPanel() {
        if (this.ivjProfileBrowserPanel == null) {
            try {
                this.ivjProfileBrowserPanel = new ProfileBrowserPanel();
                this.ivjProfileBrowserPanel.setName("ProfileBrowserPanel");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjProfileBrowserPanel;
    }

    private void handleException(Throwable exception) {
        MessageDialog.displayException(exception, this);
    }

    private void initialize() {
        try {
            this.setName("ProfileBrowserFrame");
            this.setDefaultCloseOperation(2);
            this.setSize(659, 465);
            this.setTitle("TopLink Profile Browser");
            URL iconURL = this.getClass().getResource("/tl_icon16.gif");
            if (iconURL != null) {
                this.setIconImage(new ImageIcon(iconURL).getImage());
            }
            this.setContentPane(this.getMainPanel());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        ProfileBrowser.centerComponent(this);
        this.getProfileBrowserPanel().setup();
    }

    public void setProfiles(List<Profile> profiles) {
        this.getProfileBrowserPanel().setProfiles(profiles);
    }
}

