/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.simple.mappings;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.eclipse.persistence.testing.tests.dynamic.QuerySQLTracker;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleTypes_OneToOne {
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;
    static QuerySQLTracker qTracker = null;

    @BeforeClass
    public static void setUp() {
        session = DynamicTestingHelper.createSession();
        session.setLogLevel(3);
        dynamicHelper = new DynamicHelper(session);
        DynamicClassLoader dcl = dynamicHelper.getDynamicClassLoader();
        Class simpleTypeB = dcl.createDynamicClass("simple.mappings.SimpleB");
        DynamicTypeBuilder bFactory = new DynamicTypeBuilder(simpleTypeB, null, new String[]{"SIMPLE_TYPE_B"});
        bFactory.setPrimaryKeyFields(new String[]{"SID"});
        bFactory.addDirectMapping("id", Integer.TYPE, "SID");
        bFactory.addDirectMapping("value1", String.class, "VAL_1");
        Class simpleTypeA = dcl.createDynamicClass("simple.mappings.SimpleA");
        DynamicTypeBuilder aFactory = new DynamicTypeBuilder(simpleTypeA, null, new String[]{"SIMPLE_TYPE_A"});
        aFactory.setPrimaryKeyFields(new String[]{"SID"});
        aFactory.addDirectMapping("id", Integer.TYPE, "SID");
        aFactory.addDirectMapping("value1", String.class, "VAL_1");
        aFactory.addOneToOneMapping("b", bFactory.getType(), new String[]{"B_FK"});
        dynamicHelper.addTypes(true, true, new DynamicType[]{aFactory.getType(), bFactory.getType()});
        qTracker = QuerySQLTracker.install((Session)session);
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE_A");
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE_B");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @After
    public void clearDynamicTables() {
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TYPE_A");
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TYPE_B");
        qTracker.reset();
    }

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptorA = dynamicHelper.getSession().getClassDescriptorForAlias("SimpleA");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleA'", (Object)descriptorA);
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((String)"'SimpleA' EntityType not found", (Object)simpleTypeA);
        Assert.assertEquals((Object)descriptorA, (Object)simpleTypeA.getDescriptor());
        DirectToFieldMapping a_id = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)a_id.getAttributeClassification());
        DirectToFieldMapping a_value1 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)a_value1.getAttributeClassification());
        ClassDescriptor descriptorB = dynamicHelper.getSession().getClassDescriptorForAlias("SimpleB");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleB'", (Object)descriptorB);
        DynamicType simpleTypeB = dynamicHelper.getType("SimpleB");
        Assert.assertNotNull((String)"'SimpleB' EntityType not found", (Object)simpleTypeB);
        Assert.assertEquals((Object)descriptorB, (Object)simpleTypeB.getDescriptor());
        DirectToFieldMapping b_id = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)b_id.getAttributeClassification());
        DirectToFieldMapping b_value1 = (DirectToFieldMapping)descriptorB.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)b_value1.getAttributeClassification());
        OneToOneMapping a_b = (OneToOneMapping)descriptorA.getMappingForAttributeName("b");
        Assert.assertEquals((Object)descriptorB, (Object)a_b.getReferenceDescriptor());
    }

    @Test
    public void createSimpleA() {
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicEntity simpleInstance = simpleTypeA.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"A1");
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstance);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery("SimpleA", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCount = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
    }

    @Test
    public void createSimpleB() {
        DynamicType simpleTypeB = dynamicHelper.getType("SimpleB");
        Assert.assertNotNull((Object)simpleTypeB);
        DynamicEntity simpleInstance = simpleTypeB.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"B1");
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstance);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery("SimpleB", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCount = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
    }

    @Test
    public void createSimpleAwithSimpleB() {
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicType simpleTypeB = dynamicHelper.getType("SimpleB");
        Assert.assertNotNull((Object)simpleTypeB);
        Assert.assertNotNull((Object)session.getDescriptorForAlias("SimpleB"));
        DynamicEntity simpleInstanceB = simpleTypeB.newDynamicEntity();
        simpleInstanceB.set("id", (Object)2);
        simpleInstanceB.set("value1", (Object)"B2");
        DynamicEntity simpleInstanceA = simpleTypeA.newDynamicEntity();
        simpleInstanceA.set("id", (Object)2);
        simpleInstanceA.set("value1", (Object)"A2");
        simpleInstanceA.set("b", (Object)simpleInstanceB);
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstanceA);
        uow.registerNewObject((Object)simpleInstanceB);
        uow.commit();
        Assert.assertEquals((long)2L, (long)qTracker.getTotalSQLINSERTCalls());
        Assert.assertEquals((String)"No update expected for new objects with 1:1", (long)0L, (long)qTracker.getTotalSQLUPDATECalls());
        ReportQuery countQuery = dynamicHelper.newReportQuery("SimpleB", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)1L, (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
        countQuery = dynamicHelper.newReportQuery("SimpleA", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)1L, (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
    }
}

