/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.simple.sequencing;

import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.eclipse.persistence.testing.tests.dynamic.simple.sequencing.BaseSequencingTestSuite;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class TableSequencingTestSuite
extends BaseSequencingTestSuite {
    @BeforeClass
    public static void setUp() {
        session = DynamicTestingHelper.createSession();
        dynamicHelper = new DynamicHelper(session);
        DynamicClassLoader dcl = dynamicHelper.getDynamicClassLoader();
        Class dynamicType = dcl.createDynamicClass("simple.sequencing.Simple");
        DynamicTypeBuilder typeBuilder = new DynamicTypeBuilder(dynamicType, null, new String[]{"SIMPLE_TABLE_SEQ"});
        typeBuilder.setPrimaryKeyFields(new String[]{"SID"});
        typeBuilder.addDirectMapping("id", Integer.TYPE, "SID");
        typeBuilder.addDirectMapping("value1", String.class, "VAL_1");
        TableSequence sequence = new TableSequence();
        sequence.setTableName("TEST_SEQ");
        sequence.setCounterFieldName("SEQ_VALUE");
        sequence.setNameFieldName("SEQ_NAME");
        sequence.setPreallocationSize(5);
        session.getProject().getLogin().setDefaultSequence((Sequence)sequence);
        sequence.onConnect((Platform)session.getPlatform());
        typeBuilder.configureSequencing((Sequence)sequence, "Simple_SEQ", "SID");
        dynamicHelper.addTypes(true, true, new DynamicType[]{typeBuilder.getType()});
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TABLE_SEQ");
        session.executeNonSelectingSQL("DROP TABLE TEST_SEQ");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @After
    public void clearSimpleTypeInstances() throws Exception {
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TABLE_SEQ");
        session.executeNonSelectingSQL("UPDATE TEST_SEQ SET SEQ_VALUE = 0");
        session.getSequencingControl().resetSequencing();
        session.getSequencingControl().initializePreallocated();
    }
}

