/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.mapping.OuterJoinSystem;
import org.eclipse.persistence.testing.models.mapping.Student;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class OuterJoinWithMultipleTablesTestModel
extends TestModel {
    public OuterJoinWithMultipleTablesTestModel() {
        this.setDescription("This model tests reading/writing/deleting of multiple tables using outer joins.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new OuterJoinSystem());
    }

    public void addTests() {
        this.addTest((Test)OuterJoinWithMultipleTablesTestModel.getInsertObjectTestSuite());
        this.addTest((Test)OuterJoinWithMultipleTablesTestModel.getReadObjectTestSuite());
        this.addTest((Test)OuterJoinWithMultipleTablesTestModel.getReadAllTestSuite());
        this.addTest((Test)OuterJoinWithMultipleTablesTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)OuterJoinWithMultipleTablesTestModel.getUpdateObjectTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OuterJoinWithMultipleTablesDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the outer join test model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Student.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Student.class, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Student.class, "example3")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Student.class, "example4")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Student.class, "example5")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Student.class, "example6")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(Student.class, "example7")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OuterJoinWithMultipleTablesInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the outer join test model.");
        suite.addTest((Test)new InsertObjectTest((Object)Student.example8()));
        suite.addTest((Test)new InsertObjectTest((Object)Student.example9()));
        suite.addTest((Test)new InsertObjectTest((Object)Student.example10()));
        suite.addTest((Test)new InsertObjectTest((Object)Student.example11()));
        suite.addTest((Test)new InsertObjectTest((Object)Student.example12()));
        suite.addTest((Test)new InsertObjectTest((Object)Student.example13()));
        suite.addTest((Test)new InsertObjectTest((Object)Student.example14()));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OuterJoinWithMultipleReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the mapping model.");
        suite.addTest((Test)new ReadAllTest(Student.class, 8));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OuterJoinWithMultipleTablesReadObjectTestSuite");
        suite.setDescription("This suite tests the reading of each object in the outer join test model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Student.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Student.class, "example5")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(Student.class, "example3")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OuterJoinWithMultipleTablesUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the Outer join test model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(Student.class, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Student.class, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Student.class, "example3")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Student.class, "example4")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(Student.class, "example5")));
        return suite;
    }

    public void setup() {
        if (!this.getSession().getLogin().getPlatform().isOracle() && !this.getSession().getLogin().getPlatform().isTimesTen()) {
            throw new TestWarningException("This test is not supported on this Database");
        }
    }
}

