/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.ownership;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.ownership.ObjectA;
import org.eclipse.persistence.testing.models.ownership.ObjectB;
import org.eclipse.persistence.testing.models.ownership.ObjectC;
import org.eclipse.persistence.testing.models.ownership.ObjectD;
import org.eclipse.persistence.testing.models.ownership.ObjectE;
import org.eclipse.persistence.testing.models.ownership.OwnershipSystem;
import org.eclipse.persistence.testing.tests.ownership.UnitOfWorkTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class OwnershipTestModel
extends TestModel {
    public OwnershipTestModel() {
        this.setDescription("This model tests reading/writing/deleting of the complex ownership model.");
    }

    public void addRequiredSystems() {
        this.addRequiredSystem(new OwnershipSystem());
    }

    public void addTests() {
        this.addTest((Test)OwnershipTestModel.getReadObjectTestSuite());
        this.addTest((Test)OwnershipTestModel.getReadAllTestSuite());
        this.addTest((Test)OwnershipTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)OwnershipTestModel.getInsertObjectTestSuite());
        this.addTest((Test)OwnershipTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)OwnershipTestModel.getUnitOfWorkTestSuite());
    }

    public static TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OwnershipDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the ownership model.");
        Class<ObjectA> objectAClass = ObjectA.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(objectAClass, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(objectAClass, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(objectAClass, "example3")));
        return suite;
    }

    public static TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OwnershipInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the ownership model.");
        suite.addTest((Test)new InsertObjectTest((Object)ObjectA.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)ObjectA.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)ObjectA.example3()));
        return suite;
    }

    public static TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OwnershipReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the ownership model.");
        suite.addTest((Test)new ReadAllTest(ObjectA.class, 3));
        suite.addTest((Test)new ReadAllTest(ObjectB.class, 3));
        suite.addTest((Test)new ReadAllTest(ObjectC.class, 6));
        suite.addTest((Test)new ReadAllTest(ObjectD.class, 6));
        suite.addTest((Test)new ReadAllTest(ObjectE.class, 18));
        return suite;
    }

    public static TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OwnershipReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the ownership model.");
        Class<ObjectA> objectAClass = ObjectA.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(objectAClass, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(objectAClass, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(objectAClass, "example3")));
        return suite;
    }

    public static TestSuite getUnitOfWorkTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OwnershipUnitOfWorkTestSuite");
        suite.setDescription("This suite verifies that UOW works in the ownership model");
        Class<ObjectA> objectAClass = ObjectA.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(objectAClass, "example1")));
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(objectAClass, "example2")));
        suite.addTest((Test)new UnitOfWorkTest(manager.getObject(objectAClass, "example3")));
        return suite;
    }

    public static TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("OwnershipUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the ownership model.");
        Class<ObjectA> objectAClass = ObjectA.class;
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(objectAClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(objectAClass, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(objectAClass, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(objectAClass, "example3")));
        return suite;
    }
}

