/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.Address;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;

public class UnitOfWorkUpdateTest
extends AutoVerifyTestCase {
    public UnitOfWorkUpdateTest() {
        this.setDescription("Tests updating with a UnitOfWork using Proxy Indirection.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").like("%Angie%"));
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee eClone = (Employee)uow.registerObject((Object)emp);
        eClone.getAddress().setStreet("706-171 Lees Ave.");
        eClone.setLastName("Barkhouse");
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Angie"));
        Address address = emp.getAddress();
        if (emp.getLastName().equals("MacIvor")) {
            throw new TestErrorException("Source object update did not work properly.");
        }
        if (address.getStreet().startsWith("509")) {
            throw new TestErrorException("Proxy object update did not work properly.\n" + address);
        }
    }
}

