/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public abstract class CascadingTest
extends TestCase {
    protected String m_szTestName = null;
    protected boolean m_bMaintainCache = false;
    protected int m_nCascadeType = 0;
    protected static final int NO_CASCADE = 0;
    protected static final int CASCADE_PRIVATE = 1;
    protected static final int CASCADE_ALL = 2;
    protected Employee employeeFromDatabase;
    protected Employee m_reloadedEmployee;
    protected String m_szManagedEmployee;
    protected String m_szFirstName;
    protected String m_szPhoneNumber;

    public CascadingTest() {
        this.setTestConfiguration();
    }

    protected void cascadeCheck() {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject((Object)this.employeeFromDatabase);
        if (!this.m_bMaintainCache) {
            if (!this.m_reloadedEmployee.getFirstName().equals(this.m_szFirstName)) {
                throw new TestErrorException(this.m_szTestName + " test failed on firstName");
            }
            if (this.m_nCascadeType == 1 && !((PhoneNumber)this.m_reloadedEmployee.getPhoneNumbers().elementAt(0)).getType().equals(this.m_szPhoneNumber)) {
                throw new TestErrorException(this.m_szTestName + ": private cascaded parts were not refreshed from db");
            }
            if (this.m_nCascadeType == 2 && !((Employee)this.m_reloadedEmployee.getManagedEmployees().elementAt(0)).getFirstName().equals(this.m_szManagedEmployee)) {
                throw new TestErrorException(this.m_szTestName + ": public cascaded parts were not refreshed from db");
            }
            for (int loop = 0; loop < 5; ++loop) {
                this.employeeFromDatabase.setFirstName("Refresh too fast");
                ReadObjectQuery refreshQuery = new ReadObjectQuery((Object)this.employeeFromDatabase);
                refreshQuery.refreshIdentityMapResult();
                this.getSession().executeQuery((DatabaseQuery)refreshQuery);
                if (this.employeeFromDatabase.getFirstName().equals(this.m_szFirstName)) continue;
                throw new TestErrorException(this.m_szTestName + ": test failed on firstName loop-" + loop);
            }
        } else {
            if (!this.employeeFromDatabase.getFirstName().equals(this.m_szFirstName)) {
                throw new TestErrorException(this.m_szTestName + ": test failed on firstName");
            }
            if (this.m_nCascadeType == 1 && !((PhoneNumber)this.employeeFromDatabase.getPhoneNumbers().elementAt(0)).getType().equals(this.m_szPhoneNumber)) {
                throw new TestErrorException(this.m_szTestName + ": private cache data not refreshed from db");
            }
            if (this.m_nCascadeType == 2 && !((Employee)this.employeeFromDatabase.getManagedEmployees().elementAt(0)).getFirstName().equals(this.m_szManagedEmployee)) {
                throw new TestErrorException(this.m_szTestName + ":public cache data not refreshed from db");
            }
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setConfiguration(String szTestName, boolean bMaintainCache, int nCascadeSetting) {
        this.m_szTestName = szTestName;
        this.m_bMaintainCache = bMaintainCache;
        this.m_nCascadeType = nCascadeSetting;
    }

    abstract void setTestConfiguration();

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.m_szTestName == null) {
            throw new TestErrorException("CascadingTest: Subclass did not initialize test properly");
        }
        ExpressionBuilder expBldr = new ExpressionBuilder();
        Expression whatWeWant = expBldr.get("lastName").equal((Object)"May");
        this.employeeFromDatabase = (Employee)this.getSession().readObject(Employee.class, whatWeWant);
    }

    public void test() {
        this.m_szFirstName = this.employeeFromDatabase.getFirstName();
        this.m_szPhoneNumber = ((PhoneNumber)this.employeeFromDatabase.getPhoneNumbers().elementAt(0)).getType();
        this.m_szManagedEmployee = ((Employee)this.employeeFromDatabase.getManagedEmployees().elementAt(0)).getFirstName();
        this.employeeFromDatabase.setFirstName("Foobar");
        ((PhoneNumber)this.employeeFromDatabase.getPhoneNumbers().elementAt(0)).setType("FooNumber");
        ((Employee)this.employeeFromDatabase.getManagedEmployees().elementAt(0)).setFirstName("MrFoobar");
    }

    protected void verify() {
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject((Object)this.employeeFromDatabase);
        if (this.m_bMaintainCache) {
            query.refreshIdentityMapResult();
        } else {
            query.dontMaintainCache();
        }
        switch (this.m_nCascadeType) {
            case 1: {
                query.cascadePrivateParts();
                break;
            }
            case 2: {
                query.cascadeAllParts();
                break;
            }
            default: {
                query.dontCascadeParts();
            }
        }
        this.m_reloadedEmployee = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        this.cascadeCheck();
    }
}

