/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.List;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.legacy.Shipment;

public class OneToManyBatchReadingTest
extends TestCase {
    BatchFetchType batchType;
    public List result;

    public OneToManyBatchReadingTest(BatchFetchType batchType) {
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
        this.setDescription("Tests batch reading using 1 to 1 mapping and composite primary key");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
        if (this.batchType == BatchFetchType.IN && !this.getSession().getPlatform().isOracle()) {
            this.throwWarning("Nested arrays not supported on this database");
        }
    }

    public void test() {
        ReadAllQuery q = new ReadAllQuery();
        q.setBatchFetchType(this.batchType);
        q.setReferenceClass(Shipment.class);
        q.addBatchReadAttribute("orders");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.result = (List)uow.executeQuery((DatabaseQuery)q);
    }

    public void verify() {
        Shipment shipment = (Shipment)this.result.get(0);
        this.strongAssert(shipment.orders.size() > 0, "Test failed. Batched objects were not read");
    }
}

