/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.relationshipmaintenance;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.relationshipmaintenance.Dept;
import org.eclipse.persistence.testing.models.relationshipmaintenance.Emp;

public class DeepMergeCloneSerializedNewTest
extends AutoVerifyTestCase {
    public Dept origional;
    public Dept mergedClone;
    public Dept deptObject;

    public DeepMergeCloneSerializedNewTest() {
        this.setDescription("This test verifies that deepMergeClone works after a serialized transaction");
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.rollbackTransaction();
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    public void setup() {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("This test cannot be run through the remote.");
        }
        this.beginTransaction();
    }

    public void test() {
        try {
            Dept deserialDept;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(byteStream);
            Session session = this.getSession();
            UnitOfWork uow = session.acquireUnitOfWork();
            this.deptObject = (Dept)session.readObject(Dept.class, new ExpressionBuilder().get("deptno").equal(5.0));
            this.deptObject.getEmpCollection().size();
            stream.writeObject(this.deptObject);
            stream.flush();
            byte[] arr = byteStream.toByteArray();
            ByteArrayInputStream inByteStream = new ByteArrayInputStream(arr);
            ObjectInputStream inObjStream = new ObjectInputStream(inByteStream);
            try {
                deserialDept = (Dept)inObjStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new TestErrorException("Could not deserialize object " + e.toString());
            }
            Emp newEmp = new Emp();
            newEmp.setEmpno((double)System.currentTimeMillis() % 10000.0);
            newEmp.setEname("THe New Guy" + System.currentTimeMillis());
            if (deserialDept.getEmpCollection() != null && deserialDept.getEmpCollection().size() > 1) {
                deserialDept.getEmpCollection().remove(deserialDept.getEmpCollection().iterator().next());
            }
            deserialDept.getEmpCollection().add(newEmp);
            newEmp.setDeptno(deserialDept);
            int collectionSize = deserialDept.getEmpCollection().size();
            byteStream = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(byteStream);
            stream.writeObject(deserialDept);
            stream.flush();
            arr = byteStream.toByteArray();
            inByteStream = new ByteArrayInputStream(arr);
            inObjStream = new ObjectInputStream(inByteStream);
            try {
                deserialDept = (Dept)inObjStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new TestErrorException("Could not deserialize object " + e.toString());
            }
            Dept deptClone = (Dept)uow.deepMergeClone((Object)deserialDept);
            if (deptClone.getEmpCollection().size() != collectionSize) {
                throw new TestErrorException("Failed to merge the collection correctly not enough Emps");
            }
            for (Emp emp : deptClone.getEmpCollection()) {
                if (emp.getDeptno() == deptClone) continue;
                throw new TestErrorException("Failed to merge the back pointer");
            }
            uow.commit();
        }
        catch (IOException e) {
            throw new TestErrorException("Error running Test " + e.toString());
        }
    }
}

