/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;

public class EmployeeProject1
extends Project {
    public EmployeeProject1() {
        this.applyPROJECT();
        this.applyLOGIN();
        this.buildEmployeeDescriptor();
        this.buildEmploymentPeriodDescriptor();
    }

    protected void applyLOGIN() {
        DatabaseLogin login = new DatabaseLogin();
        login.setDriverClassName("sun.jdbc.odbc.JdbcOdbcDriver");
        login.setConnectionString("jdbc:odbc:MSACCESS");
        login.setPlatformClassName("org.eclipse.persistence.platform.database.AccessPlatform");
        this.setLogin(login);
    }

    protected void applyPROJECT() {
        this.setName("Employee");
    }

    protected void buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("EMPLOYEE");
        vector.addElement("SALARY");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberName("EMP_SEQ");
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.useVersionLocking("VERSION");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("period");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setReferenceClass(EmploymentPeriod.class);
        aggregateobjectmapping.setIsNullAllowed(true);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        DirectCollectionMapping directcollectionmapping = new DirectCollectionMapping();
        directcollectionmapping.setAttributeName("responsibilitiesList");
        directcollectionmapping.setIsReadOnly(false);
        directcollectionmapping.setUsesIndirection(true);
        directcollectionmapping.setIsPrivateOwned(true);
        directcollectionmapping.setDirectFieldName("RESPONS.DESCRIP");
        directcollectionmapping.setReferenceTableName("RESPONS");
        directcollectionmapping.addReferenceKeyFieldName("RESPONS.EMP_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)directcollectionmapping);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("firstName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("EMPLOYEE.F_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("lastName");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("EMPLOYEE.L_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        DirectToFieldMapping directtofieldmapping3 = new DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("salary");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("SALARY.SALARY");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping3);
        ManyToManyMapping manytomanymapping = new ManyToManyMapping();
        manytomanymapping.setAttributeName("projects");
        manytomanymapping.setIsReadOnly(false);
        manytomanymapping.setUsesIndirection(true);
        manytomanymapping.setReferenceClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        manytomanymapping.setIsPrivateOwned(false);
        manytomanymapping.setRelationTableName("PROJ_EMP");
        manytomanymapping.addSourceRelationKeyFieldName("PROJ_EMP.EMP_ID", "EMPLOYEE.EMP_ID");
        manytomanymapping.addTargetRelationKeyFieldName("PROJ_EMP.PROJ_ID", "PROJECT.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)manytomanymapping);
        DirectToFieldMapping objecttypemapping = new DirectToFieldMapping();
        objecttypemapping.setAttributeName("gender");
        objecttypemapping.setIsReadOnly(false);
        objecttypemapping.setFieldName("EMPLOYEE.GENDER");
        ObjectTypeConverter objecttypeconverter = new ObjectTypeConverter();
        objecttypeconverter.addConversionValue((Object)"F", (Object)"Female");
        objecttypeconverter.addConversionValue((Object)"M", (Object)"Male");
        objecttypemapping.setConverter((Converter)objecttypeconverter);
        descriptor.addMapping((DatabaseMapping)objecttypemapping);
        OneToManyMapping onetomanymapping = new OneToManyMapping();
        onetomanymapping.setAttributeName("managedEmployees");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(true);
        onetomanymapping.setReferenceClass(Employee.class);
        onetomanymapping.setIsPrivateOwned(false);
        onetomanymapping.addTargetForeignKeyFieldName("EMPLOYEE.MANAGER_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)onetomanymapping);
        OneToManyMapping onetomanymapping1 = new OneToManyMapping();
        onetomanymapping1.setAttributeName("phoneNumbers");
        onetomanymapping1.setIsReadOnly(false);
        onetomanymapping1.setUsesIndirection(true);
        onetomanymapping1.setReferenceClass(PhoneNumber.class);
        onetomanymapping1.setIsPrivateOwned(true);
        onetomanymapping1.addTargetForeignKeyFieldName("PHONE.EMP_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)onetomanymapping1);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("address");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setReferenceClass(Address.class);
        onetoonemapping.setIsPrivateOwned(true);
        onetoonemapping.addForeignKeyFieldName("EMPLOYEE.ADDR_ID", "ADDRESS.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        OneToOneMapping onetoonemapping1 = new OneToOneMapping();
        onetoonemapping1.setAttributeName("manager");
        onetoonemapping1.setIsReadOnly(false);
        onetoonemapping1.setUsesIndirection(true);
        onetoonemapping1.setReferenceClass(Employee.class);
        onetoonemapping1.setIsPrivateOwned(false);
        onetoonemapping1.addForeignKeyFieldName("EMPLOYEE.MANAGER_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping1);
        TransformationMapping transformationmapping = new TransformationMapping();
        transformationmapping.setAttributeName("normalHours");
        transformationmapping.setIsReadOnly(false);
        transformationmapping.setUsesIndirection(false);
        transformationmapping.setAttributeTransformation("buildNormalHours");
        transformationmapping.addFieldTransformation("EMPLOYEE.END_TIME", "getEndTime");
        transformationmapping.addFieldTransformation("EMPLOYEE.START_TIME", "getStartTime");
        descriptor.addMapping((DatabaseMapping)transformationmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildEmploymentPeriodDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmploymentPeriod.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("EMPLOYEE");
        descriptor.setTableNames(vector);
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.descriptorIsAggregate();
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("endDate");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("EMPLOYEE.END_DATE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("startDate");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("EMPLOYEE.START_DATE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }
}

