/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import junit.framework.Test;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeTableCreator;
import org.eclipse.persistence.testing.tests.employee.EmployeeBasicTestModel;
import org.eclipse.persistence.testing.tests.sessionbroker.ClientBrokerTest;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject1;
import org.eclipse.persistence.testing.tests.sessionbroker.EmployeeProject2;
import org.eclipse.persistence.testing.tests.sessionbroker.Server;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class MultipleClientBrokersTestModel
extends TestModel {
    public MultipleClientBrokersTestModel() {
        this.setDescription("This suite tests the session broker with two or more client session brokers");
    }

    public void addTests() {
        this.addTest((Test)MultipleClientBrokersTestModel.getClientBrokerTestSuite());
    }

    public void createTables() {
        SessionBroker broker = new SessionBroker();
        DatabaseSessionImpl session1 = new DatabaseSessionImpl((Login)Server.getLogin1());
        DatabaseSessionImpl session2 = new DatabaseSessionImpl((Login)Server.getLogin2());
        session1.addDescriptors((Project)new EmployeeProject1());
        session2.addDescriptors((Project)new EmployeeProject2());
        broker.registerSession("broker1", (Session)session1);
        broker.registerSession("broker2", (Session)session2);
        broker.setLogLevel(this.getSession().getLogLevel());
        broker.setLog(this.getSession().getLog());
        broker.login();
        ((ManyToManyMapping)session1.getDescriptor(Employee.class).getObjectBuilder().getMappingForAttributeName("projects")).setSessionName("broker2");
        ((OneToOneMapping)session1.getDescriptor(Employee.class).getObjectBuilder().getMappingForAttributeName("address")).setShouldVerifyDelete(false);
        EmployeeTableCreator tables = new EmployeeTableCreator();
        tables.replaceTables((DatabaseSession)session1);
        tables.replaceTables((DatabaseSession)session2);
        tables.dropConstraints((DatabaseSession)session1);
        tables.dropConstraints((DatabaseSession)session2);
        new SchemaManager((DatabaseSession)session1).createSequences();
        new SchemaManager((DatabaseSession)session2).createSequences();
        new EmployeeSystem().populate((DatabaseSession)broker);
        broker.logout();
    }

    public static TestSuite getBasicReadTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("BasicReadTestSuite");
        suite.setDescription("This suite tests the reading of objects remotely.");
        suite.addTest((Test)EmployeeBasicTestModel.getReadObjectTestSuite());
        suite.addTest((Test)EmployeeBasicTestModel.getReadAllTestSuite());
        return suite;
    }

    public static TestSuite getClientBrokerTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName(" MultipleClientBrokerTestSuite");
        suite.addTest((Test)new ClientBrokerTest());
        return suite;
    }

    public void reset() {
        this.getExecutor().removeConfigureSystem((TestSystem)new EmployeeSystem());
        this.getExecutor().getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.createTables();
    }
}

