/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.readonly.ReadOnlyProject;

public class ReadOnlyClassesInSessionBrokerTest
extends AutoVerifyTestCase {
    int vectorSize = 0;
    SessionBroker sessionBroker;

    public ReadOnlyClassesInSessionBrokerTest() {
        this.setDescription("The test for DefaultReadOnlyClasses size in session broker");
    }

    public void setup() {
        ReadOnlyProject project = new ReadOnlyProject();
        DatabaseLogin login = project.getLogin();
        login.usePlatform((DatabasePlatform)new OraclePlatform());
        login.setDriverClassName("oracle.jdbc.OracleDriver");
        login.setConnectionString("jdbc:oracle:thin:@ottvm028.ca.oracle.com:1521:toplink");
        login.setUserName("QA6");
        login.setPassword("password");
        ServerSession serverSession = (ServerSession)project.createServerSession();
        this.sessionBroker = new SessionBroker();
        this.sessionBroker.registerSession("broker1", (AbstractSession)serverSession);
        this.sessionBroker.login();
    }

    public void test() {
        for (int i = 0; i < 10; ++i) {
            this.vectorSize = this.getDefaultReadOnlyClassSize();
        }
    }

    public int getDefaultReadOnlyClassSize() {
        int size = 0;
        SessionBroker cSessionBroker = this.sessionBroker.acquireClientSessionBroker();
        size = this.sessionBroker.getDefaultReadOnlyClasses().size();
        cSessionBroker.release();
        return size;
    }

    public void verify() {
        if (this.vectorSize < 2 || this.vectorSize > 2) {
            throw new TestErrorException("DefaultReadOnlyClasses size should be 2, but " + this.vectorSize + " is returned");
        }
    }

    public void reset() {
        this.sessionBroker.logout();
    }
}

